package com.bokesoft.yes.meta.json.panel;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.tablepanel.MetaFluidTableLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.tablepanel.MetaTableColumn;
import com.bokesoft.yigo.meta.form.component.panel.tablepanel.MetaTableColumnCollection;

public class MetaFluidTableLayoutPanelJSONHandler extends BasePanelJSONHandler<MetaFluidTableLayoutPanel> {

	@Override
	public void fromJSONImpl(MetaFluidTableLayoutPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);

		meta.setRepeatCount(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATCOUNT));
		meta.setRepeatGap(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATGAP));
		meta.setRowGap(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_ROWGAP));
		meta.setColumnGap(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_COLUMNGAP));
		meta.setRowHeight(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_ROWHEIGHT));

		JSONObject layout = json.optJSONObject(JSONConstants.BASEPANEL_LAYOUT);
		JSONArray array = layout.optJSONArray(JSONConstants.FLUIDTABLELAYOUTPANEL_WIDTHS);
		if (array != null) {
			MetaTableColumnCollection columnCollection = new MetaTableColumnCollection();
			List<MetaTableColumn> list = UIJSONHandlerUtil.unbuild(MetaTableColumn.class, array);
			columnCollection.addAll(0, list);
			meta.setColumnCollection(columnCollection);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaFluidTableLayoutPanel meta,
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);

		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATCOUNT, meta.getRepeatCount());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATGAP, meta.getRepeatGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWGAP, meta.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_COLUMNGAP, meta.getColumnGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWHEIGHT, meta.getRowHeight());
	}

	@Override
	public MetaFluidTableLayoutPanel newInstance() {
		return new MetaFluidTableLayoutPanel();
	}
}
