package com.bokesoft.yes.meta.json.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.panel.flexgridpanel.MetaFlexGridLayoutPanel;

public class MetaFlexGridLayoutPanelJSONHandler  extends BasePanelJSONHandler<MetaFlexGridLayoutPanel> {

	@Override
	public void fromJSONImpl(MetaFlexGridLayoutPanel meta, JSONObject json)throws Throwable{
		super.fromJSONImpl(meta, json);
		
		meta.setColumnCount(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNCOUNT));
		meta.setColumnGap(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNGAP));
		meta.setRowGap(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_ROWGAP));
		meta.setRowHeight(json.optInt(JSONConstants.FLEXGRIDLAYOUTPANEL_ROWHEIGHT));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaFlexGridLayoutPanel meta,
			DefaultSerializeContext hook) throws Throwable{
		super.toJSONImpl(json, meta, hook);

		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNCOUNT, meta.getColumnCount());
		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_COLUMNGAP, meta.getColumnGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_ROWGAP, meta.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLEXGRIDLAYOUTPANEL_ROWHEIGHT, meta.getRowHeight());
	}
	
	@Override
	public MetaFlexGridLayoutPanel newInstance() {
		return new MetaFlexGridLayoutPanel();
	}

}
