package com.bokesoft.yes.meta.json.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.panel.FlexBoxPanel.MetaFlexBoxPanel;

public class MetaFlexBoxPanelJSONHandler extends BasePanelJSONHandler<MetaFlexBoxPanel> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaFlexBoxPanel meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.FLEXBOXPANEL_REPEATCOUNT, meta.getRepeatCount());
	}
	
	@Override
	public void fromJSONImpl(MetaFlexBoxPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setRepeatCount(json.optInt(JSONConstants.FLEXBOXPANEL_REPEATCOUNT));
	}

	@Override
	public MetaFlexBoxPanel newInstance() {
		return new MetaFlexBoxPanel();
	}
	
}
