package com.bokesoft.yes.meta.json.mobiledef;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;

public class MetaWatermarkJSONHandler extends AbstractJSONHandler<MetaWatermark, DefaultSerializeContext> {

	public void toJSONImpl(JSONObject json, MetaWatermark meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.WATERMARK_DENSITY, meta.getDensity());
		JSONHelper.writeToJSON(json, JSONConstants.WATERMARK_ROTATE, meta.getRotate());
		MetaFormat format = meta.getFormat();
		if (format != null) {
			JSONObject o = UIJSONHandlerUtil.build(format, hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT, o);
		}
		JSONHelper.writeToJSON(json, JSONConstants.WATERMARK_FORMULATEXT, meta.getFormulaText());
	}

	public void fromJSONImpl(MetaWatermark meta, JSONObject json) throws Throwable {
		meta.setDensity(json.optInt(JSONConstants.WATERMARK_DENSITY));
		meta.setRotate(Float.parseFloat(json.optString(JSONConstants.WATERMARK_ROTATE)));
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_FORMAT);
		if (o != null) {
			MetaFormat format = UIJSONHandlerUtil.unbuild(MetaFormat.class, o);
			meta.setFormat(format);
		}
		meta.setFormulaText(json.optString(JSONConstants.WATERMARK_FORMULATEXT));
	}

	@Override
	public MetaWatermark newInstance() {
		return new MetaWatermark();
	}
}