package com.bokesoft.yes.meta.json.mobiledef;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundItem;

public class MetaSoundItemJSONHandler extends AbstractJSONHandler<MetaSoundItem,SolutionSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaSoundItem meta, SolutionSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_PATH, meta.getPath());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_LEFTVOLUME, meta.getLeftVolume() + "");
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_RIGHTVOLUME, meta.getRightVolume() + "");
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_PRIORITY, meta.getPriority());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_LOOP, meta.getLoop());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_RATE, meta.getRate() + "");
	}

	@Override
	public void fromJSONImpl(MetaSoundItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setPath(json.optString(JSONConstants.MOBILEDEF_PATH));
		meta.setLeftVolume(Float.parseFloat(json.optString(JSONConstants.MOBILEDEF_LEFTVOLUME)));
		meta.setRightVolume(Float.parseFloat(json.optString(JSONConstants.MOBILEDEF_RIGHTVOLUME)));
		meta.setPriority(json.optInt(JSONConstants.MOBILEDEF_PRIORITY));
		meta.setLoop(json.optInt(JSONConstants.MOBILEDEF_LOOP));
		meta.setRate(Float.parseFloat(json.optString(JSONConstants.MOBILEDEF_RATE)));
	}

	@Override
	public MetaSoundItem newInstance() {
		return new MetaSoundItem();
	}

}
