package com.bokesoft.yes.meta.json.layout;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaLayoutItemJSONHandler;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableRowLayout;

public class MetaTableRowLayoutJSONHandler extends MetaLayoutItemJSONHandler<MetaTableRowLayout> {

	@Override
	public void toJSONImpl(JSONObject json, MetaTableRowLayout meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);

		DefSize height = meta.getHeight();
		if ( height != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, height.toString(), "");
		}
		
		DefSize width = meta.getWidth();
		if( width != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_WEIGHT, meta.getWeight() + "");
	}
	
	@Override
	public void fromJSONImpl(MetaTableRowLayout meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);

		String s = json.optString(JSONConstants.COMMON_HEIGHT);
		if (s != null && !s.isEmpty()) {
			meta.setHeight(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.COMMON_WIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setWidth(DefSize.parse(s));
		}
		
		meta.setWeight(Float.parseFloat(json.optString(JSONConstants.COMPONENT_WEIGHT)));
	}

	@Override
	public MetaTableRowLayout newInstance() {
		return new MetaTableRowLayout();
	}
	
}
