package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.util.MetaUtil;

public class MetaScriptCollectionJSONHandler extends AbstractJSONHandler<MetaScriptCollection,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaScriptCollection meta,
			DefaultSerializeContext hook) throws Throwable {
		MetaScript loadScript = MetaUtil.getLoadScript(hook.getVE().getMetaFactory(), hook.getMetaForm());
		MetaScript saveScript = MetaUtil.getSaveScript(hook.getVE().getMetaFactory(), hook.getMetaForm());
		MetaScript showScript = MetaUtil.getShowScript(hook.getVE().getMetaFactory(), hook.getMetaForm());
		
		if(loadScript != null){
			json.put(JSONConstants.SCRIPT_LOAD, loadScript.getContent());
		}
		if(saveScript != null){
			json.put(JSONConstants.SCRIPT_SAVE, saveScript.getContent());
		}
		if(showScript != null){
			json.put(JSONConstants.SCRIPT_SHOW, showScript.getContent());
		}
	}
	
	@Override
	public void fromJSONImpl(MetaScriptCollection meta, JSONObject json) throws Throwable {
		String load = json.optString(JSONConstants.SCRIPT_LOAD);
		if( load != null && !load.isEmpty() ) {
			MetaScript loadScript = new MetaScript();
			loadScript.setContent(load);
			meta.setLoad(loadScript);
		}
		
		String save = json.optString(JSONConstants.SCRIPT_SAVE);
		if( save != null && !save.isEmpty() ) {
			MetaScript saveScript = new MetaScript();
			saveScript.setContent(save);
			meta.setSave(saveScript);
		}
		
		String show = json.optString(JSONConstants.SCRIPT_SHOW);
		if( show != null && !show.isEmpty() ) {
			MetaScript showScript = new MetaScript();
			showScript.setContent(show);
			meta.setShow(showScript);
		}
	}

	@Override
	public MetaScriptCollection newInstance() {
		return new MetaScriptCollection();
	}
}