package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.dataobject.MetaLayer;

public class MetaLayerJSONHandler extends AbstractJSONHandler<MetaLayer,ISerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLayer meta, ISerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.LAYER_ITEMKEY, meta.getItemKey());
		JSONHelper.writeToJSON(json, JSONConstants.LAYER_RELATION, meta.getRelation());
		JSONHelper.writeToJSON(json, JSONConstants.LAYER_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.LAYER_COLUMNKEY, meta.getColumnKey());
	}

	@Override
	public MetaLayer newInstance() {
		return new MetaLayer();
	}

	@Override
	public void fromJSONImpl(MetaLayer meta, JSONObject json) throws Throwable {
		meta.setItemKey(json.optString(JSONConstants.LAYER_ITEMKEY));
		meta.setRelation(json.optInt(JSONConstants.LAYER_RELATION));
		meta.setTableKey(json.optString(JSONConstants.LAYER_TABLEKEY));
		meta.setColumnKey(json.optString(JSONConstants.LAYER_COLUMNKEY));
	}

}
