package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.common.MetaExtend;

public class MetaExtendJSONHandler extends AbstractJSONHandler<MetaExtend,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaExtend meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.EXTEND_CLASS, meta.getClassName());
		JSONHelper.writeToJSON(json, JSONConstants.EXTEND_ALIAS, meta.getAlias());
	}

	@Override
	public void fromJSONImpl(MetaExtend meta, JSONObject json) throws Throwable {
		meta.setClassName(json.optString(JSONConstants.EXTEND_CLASS));
		meta.setAlias(json.optString(JSONConstants.EXTEND_ALIAS));
	}

	@Override
	public MetaExtend newInstance() {
		return new MetaExtend();
	}

}
