package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.view.overrides.MetaComponentOverrides;

public class MetaComponentOverridesJSONHandler extends AbstractJSONHandler<MetaComponentOverrides,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaComponentOverrides meta,
			DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORECOLOR, meta.getForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_FONTSIZE, meta.getFontSize());
	}

	@Override
	public void fromJSONImpl(MetaComponentOverrides meta, JSONObject json) throws Throwable {
		meta.setBackColor(json.optString(JSONConstants.COMMON_BACKCOLOR));
		meta.setForeColor(json.optString(JSONConstants.COMMON_FORECOLOR));
		meta.setFontSize(json.optInt(JSONConstants.FORMAT_FONTSIZE));
	}

	@Override
	public MetaComponentOverrides newInstance() {
		// TODO Auto-generated method stub
		return new MetaComponentOverrides();
	}

}
