package com.bokesoft.yes.meta.json.form;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.theme.MetaThemeCollection;
import com.bokesoft.yigo.meta.form.component.view.MetaView;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;

public class MetaBodyJSONHandler extends AbstractJSONHandler<MetaBody,DefaultSerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaBody meta, JSONObject json) throws Throwable {
		String s = json.optString(JSONConstants.COMMON_WIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setWidth(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.COMMON_HEIGHT);
		if (s != null && !s.isEmpty()) {
			meta.setHeight(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.BODY_POPWIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setPopWidth(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.BODY_POPHEIGHT);
		if (s != null && !s.isEmpty()) {
			meta.setPopHeight(DefSize.parse(s));
		}
		
		meta.setHAlign(json.optInt(JSONConstants.COMPONENT_HALIGN));
		meta.setVAlign(json.optInt(JSONConstants.COMPONENT_VALIGN));
		meta.setOverflowX(json.optInt(JSONConstants.COMMON_OVERFLOW_X));
		meta.setOverflowY(json.optInt(JSONConstants.COMMON_OVERFLOW_Y));
		
		s = json.optString(JSONConstants.COMPONENT_TOPMARGIN);
		if (s != null && !s.isEmpty()) {
			meta.setTopMargin(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.COMPONENT_BOTTOMMARGIN);
		if (s != null && !s.isEmpty()) {
			meta.setBottomMargin(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.COMPONENT_LEFTMARGIN);
		if (s != null && !s.isEmpty()) {
			meta.setLeftMargin(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.COMPONENT_RIGHTMARGIN);
		if (s != null && !s.isEmpty()) {
			meta.setRightMargin(DefSize.parse(s));
		}
		
		meta.setProvider(json.optString(JSONConstants.BODY_PROVIDER));
		meta.setResizable(json.optBoolean(JSONConstants.BODY_RESIZABLE));
		meta.setLazyCompute(json.optBoolean(JSONConstants.BODY_LAZYCOMPUTE));
		
		JSONArray array = json.optJSONArray(JSONConstants.BODY_VIEWCOLLECTION);
		if( array != null ) {
			MetaViewCollection viewCollection = new MetaViewCollection();
			List<MetaView> list = UIJSONHandlerUtil.unbuild(MetaView.class, array);
			viewCollection.addAll(list);
			meta.setViewCollection(viewCollection);
		}
		
		array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaBlock> list = UIJSONHandlerUtil.unbuild(MetaBlock.class, array);
			meta.addAll(0, list);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaBody meta, DefaultSerializeContext hook)
			throws Throwable {
		
		DefSize width = meta.getWidth();
		if (width != null) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");
		}
		
		DefSize height = meta.getHeight();
		if ( height != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, height.toString(), "");
		}
		
		DefSize popWidth = meta.getPopWidth();
		if( popWidth != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.BODY_POPWIDTH, popWidth.toString(), "");			
		}
		
		DefSize popHeight = meta.getPopHeight();
		if( popHeight != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.BODY_POPHEIGHT, popHeight.toString(), "");			
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_HALIGN, meta.getHAlign());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_VALIGN, meta.getVAlign());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_OVERFLOW_X, meta.getOverflowX());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_OVERFLOW_Y, meta.getOverflowY());

		DefSize topMargin = meta.getTopMargin();
		if( topMargin != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_TOPMARGIN, topMargin);			
		}
		
		DefSize bottomMargin = meta.getBottomMargin();
		if( bottomMargin != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BOTTOMMARGIN, bottomMargin);
		}
		
		DefSize leftMargin = meta.getLeftMargin();
		if( leftMargin != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_LEFTMARGIN, leftMargin);
		}
		
		DefSize rightMargin = meta.getRightMargin();
		if( rightMargin != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_RIGHTMARGIN, rightMargin);
		}

		JSONHelper.writeToJSON(json, JSONConstants.BODY_PROVIDER, meta.getProvider());
		JSONHelper.writeToJSON(json, JSONConstants.BODY_RESIZABLE, meta.isResizable());
		JSONHelper.writeToJSON(json, JSONConstants.BODY_LAZYCOMPUTE, meta.isLazyCompute());
		
		MetaViewCollection viewCollection = meta.getViewCollection();
		if( viewCollection != null ) {
			JSONArray o = UIJSONHandlerUtil.buildKeyCollection(hook, viewCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BODY_VIEWCOLLECTION, o);
		}
		
		MetaThemeCollection themeCollection = meta.getThemeCollection();
		if( themeCollection != null ) {
			JSONArray o = UIJSONHandlerUtil.buildKeyCollection(hook, themeCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BODY_THEMECOLLECTION, o);
		}
		
		JSONArray blocks = new JSONArray();
		for( int i = 0,size = meta.size();i < size;i++ ) {
			MetaComponent metaCom = meta.get(i);
			if( metaCom.getControlType() == ControlType.BLOCK ) {
				JSONObject o = UIJSONHandlerUtil.build(metaCom,hook);
				blocks.put(o);
			} else {
				
			}
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, blocks);
		JSONHelper.writeToJSON(json, JSONConstants.BODY_INDEX_OF_BLOCK, 0);
		JSONHelper.writeToJSON(json, JSONConstants.BODY_ISRESIZABLE, meta.isResizable());
	}

	@Override
	public MetaBody newInstance() {
		return new MetaBody();
	}

}
