package com.bokesoft.yes.meta.json.dynamic;

import java.util.Set;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeDef;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeGroup;

public class MetaCellTypeGroupJSONHandler extends AbstractJSONHandler<MetaCellTypeGroup,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaCellTypeGroup meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, meta.getFormKey());
		
		JSONObject items = new JSONObject();
		for( MetaCellTypeDef typeDef : meta ) {
			JSONObject o = UIJSONHandlerUtil.build(typeDef,hook);
			items.put(typeDef.getKey(), o);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, items);
	}

	@Override
	public MetaCellTypeGroup newInstance() {
		return new MetaCellTypeGroup();
	}

	@SuppressWarnings("unchecked")
	@Override
	public void fromJSONImpl(MetaCellTypeGroup meta, JSONObject json) throws Throwable {
		meta.setFormKey(json.optString(JSONConstants.COMMON_FORMKEY));
		
		JSONObject items = json.optJSONObject(JSONConstants.COMMON_ITEMS);
		Set<String> keySet = items.keySet();
		for( String key : keySet ) {
			MetaCellTypeDef typeDef = UIJSONHandlerUtil.unbuild(MetaCellTypeDef.class, items.optJSONObject(key));
			meta.add(typeDef);
		}
	}
	
}
