package com.bokesoft.yes.meta.json.com.properties;

import java.math.BigDecimal;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStepEditorProperties;

public class MetaStepEditorPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaStepEditorProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaStepEditorProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_MINVALUE, meta.getMinValue().toString());
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_MAXVALUE, meta.getMaxValue().toString());

		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_STEP, meta.getStep().toString());
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_EDITTYPE, meta.getEditType());
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_SHOWTYPE, meta.getShowType());
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard());
	}

	@Override
	public void fromJSONImpl(MetaStepEditorProperties meta, JSONObject json) throws Throwable {
		meta.setMinValue(new BigDecimal(json.optString(JSONConstants.STEPEDITOR_MINVALUE)));
		meta.setMaxValue(new BigDecimal(json.optString(JSONConstants.STEPEDITOR_MAXVALUE)));
		meta.setStep(new BigDecimal(json.optString(JSONConstants.STEPEDITOR_STEP)));
		meta.setEditType(json.optInt(JSONConstants.STEPEDITOR_EDITTYPE));
		meta.setShowType(json.optInt(JSONConstants.STEPEDITOR_SHOWTYPE));
		Object o = json.opt(JSONConstants.STEPEDITOR_DISABLEKEYBOARD);
		if(o != null) {
			meta.setDisableKeyboard(Boolean.parseBoolean(o.toString()));
		}
	}

	@Override
	public MetaStepEditorProperties newInstance() {
		return new MetaStepEditorProperties();
	}
	
}
