package com.bokesoft.yes.meta.json.com.properties;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressItem;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressIndicatorProperties;

public class MetaProgressIndicatorPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaProgressIndicatorProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaProgressIndicatorProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_SOURCETYPE,meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_COMPLETEDICON, meta.getCompletedIcon());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ATTENTIONICON, meta.getAttentionIcon());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ATTENTIONTEXTCOLOR, meta.getAttentionTextColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_DEFAULTICON, meta.getDefaultIcon());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_UNCOMPLETEDLINECOLOR, meta.getUnCompletedLineColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_UNCOMPLETEDTEXTCOLOR, meta.getUnCompletedTextColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_COMPLETEDLINECOLOR, meta.getCompletedLineColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_COMPLETEDTEXTCOLOR, meta.getCompletedTextColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ORIENTATION,meta.getOrientation());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_REVERSEDRAW, meta.isReverseDraw());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_TITLECOLUMNKEY, meta.getTitleColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_MESSAGECOLUMNKEY, meta.getMessageColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_DATETIMECOLUMNKEY, meta.getDateTimeColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ISSCROLL, meta.isScroll());

		MetaProgressItemCollection collection = meta.getMetaProgressItemCollection();
		if( collection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, collection);
			JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ITEMS, array);
		}
	}

	@Override
	public void fromJSONImpl(MetaProgressIndicatorProperties meta, JSONObject json) throws Throwable {
		meta.setSourceType(json.optInt(JSONConstants.PROGRESSINDICATOR_SOURCETYPE));
		meta.setCompletedIcon(json.optString(JSONConstants.PROGRESSINDICATOR_COMPLETEDICON));
		meta.setAttentionIcon(json.optString(JSONConstants.PROGRESSINDICATOR_ATTENTIONICON));
		meta.setAttentionTextColor(json.optString(JSONConstants.PROGRESSINDICATOR_ATTENTIONTEXTCOLOR));
		meta.setDefaultIcon(json.optString(JSONConstants.PROGRESSINDICATOR_DEFAULTICON));
		meta.setUnCompletedLineColor(json.optString(JSONConstants.PROGRESSINDICATOR_UNCOMPLETEDLINECOLOR));
		meta.setUnCompletedTextColor(json.optString(JSONConstants.PROGRESSINDICATOR_UNCOMPLETEDTEXTCOLOR));
		meta.setCompletedLineColor(json.optString(JSONConstants.PROGRESSINDICATOR_COMPLETEDLINECOLOR));
		meta.setCompletedTextColor(json.optString(JSONConstants.PROGRESSINDICATOR_COMPLETEDTEXTCOLOR));
		meta.setOrientation(json.optInt(JSONConstants.PROGRESSINDICATOR_ORIENTATION));
		meta.setReverseDraw(json.optBoolean(JSONConstants.PROGRESSINDICATOR_REVERSEDRAW));
		meta.setTableKey(json.optString(JSONConstants.PROGRESSINDICATOR_TABLEKEY));
		meta.setTitleColumnKey(json.optString(JSONConstants.PROGRESSINDICATOR_TITLECOLUMNKEY));
		meta.setMessageColumnKey(json.optString(JSONConstants.PROGRESSINDICATOR_MESSAGECOLUMNKEY));
		meta.setDateTimeColumnKey(json.optString(JSONConstants.PROGRESSINDICATOR_DATETIMECOLUMNKEY));
		meta.setScroll(json.optBoolean(JSONConstants.PROGRESSINDICATOR_ISSCROLL));
		
		JSONArray array = json.optJSONArray(JSONConstants.PROGRESSINDICATOR_ITEMS);
		if( array != null ) {
			MetaProgressItemCollection collection = new MetaProgressItemCollection();
			List<MetaProgressItem> list = UIJSONHandlerUtil.unbuild(MetaProgressItem.class, array);
			collection.addAll(list);
			meta.setMetaProgressItemCollection(collection);
		}
	}

	@Override
	public MetaProgressIndicatorProperties newInstance() {
		return new MetaProgressIndicatorProperties();
	}
}
