package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelItem;

public class MetaPriceLabelItemJSONHandler extends AbstractJSONHandler<MetaPriceLabelItem, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaPriceLabelItem meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.PRICELABEL_ITEM_TYPE, meta.getType());

		MetaFormat format = meta.getFormat();
		if (format != null) {
			JSONObject o = UIJSONHandlerUtil.build(format, hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT, o);
		}
	}

	@Override
	public void fromJSONImpl(MetaPriceLabelItem meta, JSONObject json) throws Throwable {
		meta.setType(json.optInt(JSONConstants.PRICELABEL_ITEM_TYPE));

		JSONObject o = json.optJSONObject(JSONConstants.COMMON_FORMAT);
		if (o != null) {
			MetaFormat format = UIJSONHandlerUtil.unbuild(MetaFormat.class, o);
			meta.setFormat(format);
		}
	}

	@Override
	public MetaPriceLabelItem newInstance() {
		return new MetaPriceLabelItem();
	}

}
