package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;

public class MetaNumberEditorPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaNumberEditorProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaNumberEditorProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_DECPRECISION, meta.getPrecision());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_DECSCALE, meta.getScale());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_USEGROUPINGSEPARATOR, meta.isUseGroupingSeparator());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SELECTONFOCUS, meta.isSelectOnFocus());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MOBILESELECTONFOCUS, meta.isMobileSelectOnFocus());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_ROUNDINGMODE, meta.getRoundingMode());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_ZEROSTRING, meta.getZeroString());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_NEGTIVEFORECOLOR, meta.getNegtiveForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SHOWZERO, meta.isShowZero());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, hook.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText()));
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_FORMATSTYLE, meta.getFormatStyle());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_IMEOPTIONS, meta.getImeOptions());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_STRIPTRAILINGZEROS, meta.getStripTrailingZeros());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_INTEGERVALUE, meta.integerValue());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SUFFIX, meta.getSuffix());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_PREFIX, meta.getPrefix());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_FORMULATEXT, meta.getFormulaText());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_ALLOWNULL, meta.getAllowNull());
		MetaBaseScript onFocus = meta.getOnFocus();
		if(onFocus != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnFocus, onFocus.getContent());
		} 
	}

	@Override
	public void fromJSONImpl(MetaNumberEditorProperties meta, JSONObject json) throws Throwable {
		meta.setPrecision(json.optInt(JSONConstants.NUMBEREDITOR_DECPRECISION));
		meta.setScale(json.optInt(JSONConstants.NUMBEREDITOR_DECSCALE));
		meta.setUseGroupingSeparator(json.optBoolean(JSONConstants.NUMBEREDITOR_USEGROUPINGSEPARATOR));
		meta.setSelectOnFocus(json.optBoolean(JSONConstants.NUMBEREDITOR_SELECTONFOCUS));
		meta.setMobileSelectOnFocus(json.optBoolean(JSONConstants.TEXTEDITOR_MOBILESELECTONFOCUS));
		meta.setRoundingMode(json.optInt(JSONConstants.NUMBEREDITOR_ROUNDINGMODE));
		meta.setZeroString(json.optString(JSONConstants.NUMBEREDITOR_ZEROSTRING));
		meta.setNegtiveForeColor(json.optString(JSONConstants.NUMBEREDITOR_NEGTIVEFORECOLOR));
		meta.setShowZero(json.optBoolean(JSONConstants.NUMBEREDITOR_SHOWZERO));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setFormatStyle(json.optInt(JSONConstants.NUMBEREDITOR_FORMATSTYLE));
		meta.setImeOptions(json.optInt(JSONConstants.NUMBEREDITOR_IMEOPTIONS));
		meta.setStripTrailingZeros(json.optBoolean(JSONConstants.NUMBEREDITOR_STRIPTRAILINGZEROS));
		meta.setIntegerValue(json.optBoolean(JSONConstants.NUMBEREDITOR_INTEGERVALUE));
		meta.setSuffix(json.optString(JSONConstants.NUMBEREDITOR_SUFFIX));
		meta.setPrefix(json.optString(JSONConstants.NUMBEREDITOR_PREFIX));
		meta.setFormulaText(json.optString(JSONConstants.NUMBEREDITOR_FORMULATEXT));
		meta.setAllowNull(json.optBoolean(JSONConstants.NUMBEREDITOR_ALLOWNULL));
		Object o = json.opt(JSONConstants.NUMBEREDITOR_DISABLEKEYBOARD);
		if(o != null) {
			meta.setDisableKeyboard(Boolean.parseBoolean(o.toString()));
		}
		String s = json.optString(JSONConstants.Event_OnFocus);
		if (s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnFocus);
			script.setContent(s);
			meta.setOnFocus(script);
		}
	}

	@Override
	public MetaNumberEditorProperties newInstance() {
		return new MetaNumberEditorProperties();
	}
}
