package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNoticeBarProperties;

public class MetaNoticeBarPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaNoticeBarProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaNoticeBarProperties meta, DefaultSerializeContext hook, String key)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.NOTICEBAR_PREICON, meta.getPreIcon());
		JSONHelper.writeToJSON(json, JSONConstants.NOTICEBAR_ACTIONICON, meta.getActionIcon());
		JSONHelper.writeToJSON(json, JSONConstants.NOTICEBAR_SCROLLABLE, meta.getScrollable());
		JSONHelper.writeToJSON(json, JSONConstants.NOTICEBAR_SINGLELINE, meta.getSingleLine());
		JSONHelper.writeToJSON(json, JSONConstants.NOTICEBAR_ORIENTATION, meta.getOrientation());

		MetaBaseScript action = meta.getAction();
		if (action != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_Action, action.getContent().trim());
		}
	}

	@Override
	public void fromJSONImpl(MetaNoticeBarProperties meta, JSONObject json) throws Throwable {
		meta.setPreIcon(json.optString(JSONConstants.NOTICEBAR_PREICON));
		meta.setActionIcon(json.optString(JSONConstants.NOTICEBAR_ACTIONICON));
		meta.setScrollable(json.optBoolean(JSONConstants.NOTICEBAR_SCROLLABLE));
		meta.setSingleLine(json.optBoolean(JSONConstants.NOTICEBAR_SINGLELINE));
		meta.setOrientation(json.optInt(JSONConstants.NOTICEBAR_ORIENTATION));
		String actionStr = json.optString(JSONConstants.Event_Action);
		if (actionStr != null && !actionStr.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_Action);
			script.setContent(actionStr);
			meta.setAction(script);
		}
	}

	@Override
	public MetaNoticeBarProperties newInstance() {
		return new MetaNoticeBarProperties();
	}

}
