package com.bokesoft.yes.meta.json.com.properties;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItemCollection;

public class MetaMultiStateButtonPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaMultiStateButtonProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaMultiStateButtonProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_ICONLOCATION, meta.getIconLocation());
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim());
		}
		
		MetaStateItemCollection collection = meta.getItemCollection();
		if(collection != null){
			JSONArray array = this.buildItems(key, collection, hook);
			JSONHelper.writeToJSON(json, JSONConstants.MULTISTATEBUTTON_STATEITEM, array);
		}
	}

	@Override
	public void fromJSONImpl(MetaMultiStateButtonProperties meta, JSONObject json) throws Throwable {
		meta.setIconLocation(json.optInt(JSONConstants.BUTTON_ICONLOCATION));
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.MULTISTATEBUTTON_STATEITEM);
		if( array != null ) {
			MetaStateItemCollection collection = unbuild(array);
			meta.setItemCollection(collection);
		}
	}
	
	@Override
	public MetaMultiStateButtonProperties newInstance() {
		return new MetaMultiStateButtonProperties();
	}
	
	private JSONArray buildItems(String key, MetaStateItemCollection collection, DefaultSerializeContext hook) throws Throwable{
		JSONArray array = new JSONArray();
		Iterator<MetaStateItem> it = collection.iterator();
		MetaStateItem item = null;
		while(it.hasNext()) {
			item = it.next();
			JSONObject o = new JSONObject();
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_KEY, item.getKey());
			String text = hook.getString(GroupKeyTable.STR_ITEMS, key, "Item-"+item.getKey(), item.getText());
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_TEXT, text);
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_VALUE, item.getValue());
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_ICON, item.getIcon());
			array.put(o);
		}
		return array;
	}
	
	private MetaStateItemCollection unbuild(JSONArray array) {
		MetaStateItemCollection collection = new MetaStateItemCollection();
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject o = array.optJSONObject(i);
			MetaStateItem item = new MetaStateItem();
			item.setKey(o.optString(JSONConstants.STATEITEM_KEY));
			item.setText(o.optString(JSONConstants.STATEITEM_TEXT));
			item.setValue(o.optString(JSONConstants.STATEITEM_VALUE));
			item.setIcon(o.optString(JSONConstants.STATEITEM_ICON));
			collection.add(item);
		}
		return collection;
	}

}
