package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.MetaImageListItem;

public class MetaImageListItemJSONHandler extends AbstractJSONHandler<MetaImageListItem,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaImageListItem meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUE, meta.getValue());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGE, meta.getImage());
	}

	@Override
	public void fromJSONImpl(MetaImageListItem meta, JSONObject json) throws Throwable {
		meta.setValue(json.optString(JSONConstants.COMMON_VALUE));
		meta.setImage(json.optString(JSONConstants.IMAGE_IMAGE));
	}

	@Override
	public MetaImageListItem newInstance() {
		return new MetaImageListItem();
	}

}
