package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCellFormat;

public class MetaGridCellFormatJSONHandler extends AbstractJSONHandler<MetaGridCellFormat,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaGridCellFormat meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HALIGN, meta.getHAlign());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALIGN, meta.getVAlign());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_LEFTBORDER, meta.isLeftBorder());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_RIGHTBORDER, meta.isRightBorder());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_TOPBORDER, meta.isTopBorder());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_BOTTOMBORDER, meta.isBottomBorder());
		
		MetaFont font = meta.getFont();
		if( font != null ) {
			JSONObject o = UIJSONHandlerUtil.build(font,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORMAT_FONT, o);
		}
	}

	@Override
	public MetaGridCellFormat newInstance() {
		return new MetaGridCellFormat();
	}

	@Override
	public void fromJSONImpl(MetaGridCellFormat meta, JSONObject json) throws Throwable {
		meta.setHAlign(json.optInt(JSONConstants.COMMON_HALIGN));
		meta.setVAlign(json.optInt(JSONConstants.COMMON_VALIGN));
		meta.setLeftBorder(json.optBoolean(JSONConstants.FORMAT_LEFTBORDER));
		meta.setRightBorder(json.optBoolean(JSONConstants.FORMAT_RIGHTBORDER));
		meta.setTopBorder(json.optBoolean(JSONConstants.FORMAT_TOPBORDER));
		meta.setBottomBorder(json.optBoolean(JSONConstants.FORMAT_BOTTOMBORDER));
		
		JSONObject o = json.optJSONObject(JSONConstants.FORMAT_FONT);
		if( o != null ) {
			MetaFont font = UIJSONHandlerUtil.unbuild(MetaFont.class, o);
			meta.setFont(font);
		}
	}

}