package com.bokesoft.yes.meta.json.com.comp;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.chart.MetaCategory;
import com.bokesoft.yigo.meta.form.component.chart.MetaChart;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartDataSource;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartTemplate;
import com.bokesoft.yigo.meta.form.component.chart.MetaSeries;

public class MetaChartJSONHandler extends BaseComponentJSONHandler<MetaChart> {
	
	@Override
	public void fromJSONImpl(MetaChart meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		JSONObject o = json.optJSONObject(JSONConstants.CHART_DATASOURCE);
		if( o != null ) {
			MetaChartDataSource dataSource = this.unbuildDataSource(o);
			meta.setDataSource(dataSource);
		}
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		meta.setChartType(json.optInt(JSONConstants.CHART_CHARTTYPE));
		meta.setSourceType(json.optInt(JSONConstants.CHART_SOURCETYPE));
		meta.setTitle(json.optString(JSONConstants.CHART_TITLE));
		meta.setSeriesInRow(json.optBoolean(JSONConstants.CHART_SERICESINROW));
		meta.setSeriesAxisTitle(json.optString(JSONConstants.CHART_SERICESAXISTITLE));
		meta.setCategoryAxisTitle(json.optString(JSONConstants.CHART_CATEGORYAXISTITLE));
		meta.setShowValue(json.optBoolean(JSONConstants.CHART_SHOWVALUES));
		meta.setFill(json.optBoolean(JSONConstants.CHART_FILL));
		meta.setHasAnimation(json.optBoolean(JSONConstants.CHART_HASANIMATION));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaChart meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		MetaChartDataSource dataSource = meta.getDataSource();
		if(dataSource != null){
			JSONObject o = this.buildDataSource(dataSource, meta.getKey(), hook);
			JSONHelper.writeToJSON(json, JSONConstants.CHART_DATASOURCE, o);
		}
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim());
		}
		JSONHelper.writeToJSON(json, JSONConstants.CHART_CHARTTYPE, meta.getChartType());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_TITLE, hook.getString(GroupKeyTable.STR_CHART, meta.getKey(), "Title", meta.getTitle()));
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SERICESINROW, meta.getSeriesInRow());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SERICESAXISTITLE, hook.getString(GroupKeyTable.STR_CHART, meta.getKey(), "SeriesAxisTitle", meta.getSeriesAxisTitle()));		
		JSONHelper.writeToJSON(json, JSONConstants.CHART_CATEGORYAXISTITLE, hook.getString(GroupKeyTable.STR_CHART,meta.getKey(), "CategoryAxisTitle", meta.getCategoryAxisTitle()));
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SHOWVALUES, meta.isShowValue());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_FILL, meta.isFill());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_HASANIMATION, meta.isHasAnimation());
		
		MetaChartTemplate chartTemplate = meta.getChartTemplate();
		 if(chartTemplate != null){
			 JSONObject childJSON = UIJSONHandlerUtil.build(chartTemplate,hook);
	         JSONHelper.writeToJSON(json, JSONConstants.CHART_TEMPLATE, childJSON);
	     }
		
	}
	
	private JSONObject buildDataSource(MetaChartDataSource meta, String key, DefaultSerializeContext hook) throws Throwable {
		JSONObject json = new JSONObject();
		MetaCategory category = meta.getCategory();
		if( category != null ) {
			JSONObject categoryJSON = new JSONObject();
			categoryJSON.put(JSONConstants.CHART_DATAKEY, category.getDataKey());
			json.put(JSONConstants.CHART_CATEGORY, categoryJSON);			
		}
		
		List<MetaSeries> list = meta.getSeriesArray();
		JSONArray array = new JSONArray();
		for(MetaSeries series : list){
			JSONObject seriesJSON = new JSONObject();
			seriesJSON.put(JSONConstants.CHART_SPLITDATAKEY, series.getSplitDataKey());
			seriesJSON.put(JSONConstants.CHART_DATAKEY, series.getDataKey());
			seriesJSON.put(JSONConstants.CHART_TITLE, hook.getString(GroupKeyTable.STR_CHART, key, "Series-"+series.getDataKey(), series.getTitle()));
			array.put(seriesJSON);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SERIES, array);
		JSONHelper.writeToJSON(json, JSONConstants.CHART_BINDINGKEY, meta.getBindingKey());
		
		return json;
	}
	
	private MetaChartDataSource unbuildDataSource(JSONObject json) {
		MetaChartDataSource dataSource = new MetaChartDataSource();
		
		JSONObject o = json.optJSONObject(JSONConstants.CHART_CATEGORY);
		if( o != null ) {
			MetaCategory category = new MetaCategory();
			category.setDataKey(o.optString(JSONConstants.CHART_DATAKEY));
			dataSource.setCategory(category);
		}
		
		List<MetaSeries> seriesArray = new ArrayList<>();
 		JSONArray array = json.optJSONArray(JSONConstants.CHART_SERIES);
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject seriesObj = array.getJSONObject(i);
			MetaSeries series = new MetaSeries();
			series.setSplitDataKey(seriesObj.optString(JSONConstants.CHART_SPLITDATAKEY));
			series.setDataKey(seriesObj.optString(JSONConstants.CHART_DATAKEY));
			series.setTitle(seriesObj.optString(JSONConstants.CHART_TITLE));
			seriesArray.add(series);
		}
		
		dataSource.setSeriesArray(seriesArray);
		dataSource.setBindingKey(json.optString(JSONConstants.CHART_BINDINGKEY));
		
		return dataSource;
	}

	@Override
	public MetaChart newInstance() {
		return new MetaChart();
	}
}
