package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaBlockJSONHandler extends AbstractJSONHandler<MetaBlock,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaBlock meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BLOCK_ISROOT, meta.isRoot());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		MetaComponent root = meta.getRoot();
		if( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.BLOCK_ROOT, o);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaBlock meta, JSONObject json) throws Throwable {
		meta.setIsRoot(json.optBoolean(JSONConstants.BLOCK_ISROOT));
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		JSONObject o = json.optJSONObject(JSONConstants.BLOCK_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
	}

	@Override
	public MetaBlock newInstance() {
		return new MetaBlock();
	}

}
