package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaJoin;

public class MetaJoinJSONHandler<T extends MetaJoin> extends MetaNodeJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setJoinCount(json.optInt(JSONConstants.NODE_JOINCOUNT));
		meta.setMateForkID(json.optInt(JSONConstants.NODE_MATE_FORKID));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_JOINCOUNT, meta.getJoinCount());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_MATE_FORKID, meta.getMateForkID());
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public T newInstance() {
		return (T) new MetaJoin();
	}
}
