package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.expand.MetaExpand;

public class MetaExpandJSONHandler extends AbstractJSONHandler<MetaExpand, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaExpand meta, JSONObject json) throws Throwable {
		meta.setBPMGraphInfoPath(json.optString(JSONConstants.BPM_GRAPHINFO_PATH));
		meta.setWorkFlowHookPath(json.optString(JSONConstants.BPM_WORKFLOWHOOK_PATH));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaExpand meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.BPM_GRAPHINFO_PATH, meta.getBPMGraphInfoPath());
		JSONHelper.writeToJSON(json, JSONConstants.BPM_WORKFLOWHOOK_PATH, meta.getWorkFlowHookPath());
		
	}
	
	@Override
	public MetaExpand newInstance() {
		return new MetaExpand();
	}
}
