package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;

public class MetaDictionaryJSONHandler extends AbstractJSONHandler<MetaDictionary, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaDictionary meta, JSONObject json) throws Throwable {
		meta.setDictionaryKey(json.optString(JSONConstants.PARTICIPATOR_DICTIONARYKEY));
		meta.setItemID(json.optString(JSONConstants.PARTICIPATOR_ITEMID));
		meta.setCode(json.optString(JSONConstants.PARTICIPATOR_CODE));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDictionary meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.PARTICIPATOR_DICTIONARYKEY, meta.getDictionaryKey());
		JSONHelper.writeToJSON(json, JSONConstants.PARTICIPATOR_ITEMID, meta.getItemID());
		JSONHelper.writeToJSON(json, JSONConstants.PARTICIPATOR_CODE, meta.getCode());
		
	}
	
	@Override
	public MetaDictionary newInstance() {
		return new MetaDictionary();
	}
}
