package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaConditonExternalLink;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDecision;

public class MetaDecisionJSONHandler extends MetaNodeJSONHandler<MetaDecision> {

	@Override
	public void fromJSONImpl(MetaDecision meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setCondition(json.optString(JSONConstants.COMMON_CONDITION));
		
		JSONObject o = json.optJSONObject(JSONConstants.BPM_CONDITIONEXTERNALLINK);
		if(o != null){
			MetaConditonExternalLink conditionExternalLink = BPMJSONHandlerUtil.unbuild(MetaConditonExternalLink.class, o);
			meta.setConditonExternalLink(conditionExternalLink);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDecision meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CONDITION, meta.getCondition());
		
		MetaConditonExternalLink conditionExternalLink = meta.getConditonExternalLink();
		if(conditionExternalLink != null){
			JSONObject o = BPMJSONHandlerUtil.build(conditionExternalLink, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_CONDITIONEXTERNALLINK, o);
		}
	}
	
	@Override
	public MetaDecision newInstance() {
		return new MetaDecision();
	}
}
