package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataSpecification;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataInput;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataOutput;

public class MetaDataSpecificationJSONHandler extends AbstractJSONHandler<MetaDataSpecification, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaDataSpecification meta, JSONObject json) throws Throwable {
		JSONObject o = json.optJSONObject(JSONConstants.BPM_DATAINPUT);
		if(o != null){
			MetaDataInput dataInput = BPMJSONHandlerUtil.unbuild(MetaDataInput.class, o);
			meta.setDataInput(dataInput);
		}
		o = json.optJSONObject(JSONConstants.BPM_DATAOUTPUT);
		if(o != null){
			MetaDataOutput dataOutput = BPMJSONHandlerUtil.unbuild(MetaDataOutput.class, o);
			meta.setDataOutput(dataOutput);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDataSpecification meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		MetaDataInput dataInput = meta.getDataInput();
		if(dataInput != null){
			JSONObject o = BPMJSONHandlerUtil.build(dataInput, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_DATAINPUT, o);
		}
		MetaDataOutput dataOutput = meta.getDataOutput();
		if(dataOutput != null){
			JSONObject o = BPMJSONHandlerUtil.build(dataOutput, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_DATAOUTPUT, o);
		}
		
	}
	
	@Override
	public MetaDataSpecification newInstance() {
		return new MetaDataSpecification();
	}
}
