package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBillDataMapInfo;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBillDataMapInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataMap;

public class MetaDataMapJSONHandler extends MetaUserTaskJSONHandler<MetaDataMap> {

	@Override
	public void fromJSONImpl(MetaDataMap meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setMidDataMap(json.optBoolean(JSONConstants.NODE_MID_DATA_MAP));
		meta.setSyncTriggerType(json.optInt(JSONConstants.NODE_SYNC_TRIGGER_TYPE));
		meta.setDataMapCondition(json.optString(JSONConstants.NODE_DATA_MAP_CONDITION));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_BILLDATAMAPINFOCOLLECTION);
		if(array != null){
			MetaBillDataMapInfoCollection billDataMapInfoCollection = new MetaBillDataMapInfoCollection();
			billDataMapInfoCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaBillDataMapInfo.class, array));
			meta.setBillDataMapInfoCollection(billDataMapInfoCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDataMap meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_MID_DATA_MAP, meta.getMidDataMap());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_SYNC_TRIGGER_TYPE, meta.getSyncTriggerType());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_DATA_MAP_CONDITION, meta.getDataMapCondition());
		
		MetaBillDataMapInfoCollection billDataMapInfoCollection = meta.getBillDataMapInfoCollection();
		if(billDataMapInfoCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, billDataMapInfoCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_BILLDATAMAPINFOCOLLECTION, array);
		}
	}
	
	@Override
	public MetaDataMap newInstance() {
		return new MetaDataMap();
	}
}
