package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachment;

public class MetaAttachmentJSONHandler extends MetaItemJSONHandler<MetaAttachment> {

	@Override
	public void fromJSONImpl(MetaAttachment meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setPara(json.optString(JSONConstants.ATTACHMENT_PARA));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaAttachment meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.ATTACHMENT_PARA, meta.getPara());
	}
	
	@Override
	public MetaAttachment newInstance() {
		return new MetaAttachment();
	}
}
