package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.AbstractWorkitemTimer;

public abstract class AbstractWorkitemTimerJSONHandler<T extends AbstractWorkitemTimer> extends AbstractTimerJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setUserInfo(json.optString(JSONConstants.TIMER_USER_INFO));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_USER_INFO, meta.getUserInfo());
	}
}
