package com.bokesoft.yes.meta.json;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaExtend;
import com.bokesoft.yigo.meta.common.MetaExtendCollection;
import com.bokesoft.yigo.meta.common.MetaKeyHandler;
import com.bokesoft.yigo.meta.common.MetaKeyHandlerCollection;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaEventHandler;
import com.bokesoft.yigo.meta.form.MetaEventHandlerCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.form.MetaTimerTask;
import com.bokesoft.yigo.meta.form.MetaTimerTaskCollection;
import com.bokesoft.yigo.meta.form.MetaUICalcExpr;
import com.bokesoft.yigo.meta.form.MetaUICalcExprCollection;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.MetaVariant;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeGroup;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;
import com.bokesoft.yigo.meta.util.MetaUtil;
/**
 * 
 * MetaBaserScript简单处理,只序列化content
 *
 */
public class MetaFormJSONHandler extends AbstractJSONHandler<MetaForm,DefaultSerializeContext>{
	
	@Override
	public void fromJSONImpl(MetaForm meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setAliasKey(json.optString(JSONConstants.FORM_ALIASKEY));
		meta.setTemplateKey(json.optString(JSONConstants.FORM_TEMPLATEKEY));
		meta.setProjectKey(json.optString(JSONConstants.COMMON_PROJECTKEY));
		meta.setFormulaCaption(json.optString(JSONConstants.FORM_FORMULACAPTION));
		meta.setFormulaAbbrCaption(json.optString(JSONConstants.FORM_FORMULAABBRCAPTION));
		meta.setAbbrCaption(json.optString(JSONConstants.FORM_ABBRCAPTION));
		
		meta.setInitState(json.optInt(JSONConstants.FORM_INITSTATE));
		meta.setFormType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setPlatform(json.optInt(JSONConstants.FORM_PLATFORM));
		
		JSONObject o = json.optJSONObject(JSONConstants.FORM_DATASOURCE);
		if( o != null ) {
			MetaDataSource dataSource = UIJSONHandlerUtil.unbuild(MetaDataSource.class, o);
			meta.setDataSource(dataSource);
		}
		
		o = json.optJSONObject(JSONConstants.FORM_OPERATIONCOLLECTION);
		if( o != null ) {
			MetaOperationCollection operationCollection = UIJSONHandlerUtil.unbuild(MetaOperationCollection.class, o);
			meta.setOperationCollection(operationCollection);
		}
		
		o = json.optJSONObject(JSONConstants.FORM_SCRIPTCOLLECTION);
		if( o != null ) {
			MetaScriptCollection scriptCollection = UIJSONHandlerUtil.unbuild(MetaScriptCollection.class, o);
			meta.setScriptCollection(scriptCollection);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.FORM_KEYHANDLERCOLLECTION);
		if( array != null ) {
			MetaKeyHandlerCollection keyHandlerCollection = new MetaKeyHandlerCollection();
			keyHandlerCollection.addAll(0, UIJSONHandlerUtil.unbuild(MetaKeyHandler.class, array));
			meta.setKeyHandlerCollection(keyHandlerCollection);
		}
		
		array = json.optJSONArray(JSONConstants.FORM_UICHECKRULECOLLECTION);
		if(array != null){
			MetaUICheckRuleCollection uiCheckRuleCollection = new MetaUICheckRuleCollection();
			uiCheckRuleCollection.addAll(0, UIJSONHandlerUtil.unbuild(MetaUICheckRule.class, array));
			meta.setUICheckRuleCollection(uiCheckRuleCollection);
		}

		array = json.optJSONArray(JSONConstants.FORM_PARACOLLECTION);
		if( array != null ) {
			MetaFormParaCollection paraCollection = new MetaFormParaCollection();
			paraCollection.addAll(0, UIJSONHandlerUtil.unbuild(MetaFormPara.class, array));
			meta.setFormParaCollection(paraCollection);
		}
		
		o = json.optJSONObject(JSONConstants.FORM_BODY);
		if( o != null ) {
			MetaBody metaBody = UIJSONHandlerUtil.unbuild(MetaBody.class, o);
			meta.setMetaBody(metaBody);
		}
		
		String s = json.optString(JSONConstants.FORM_ONLOAD);
		if( s != null ) {
			MetaBaseScript onLoad = new MetaBaseScript(MetaConstants.Event_OnLoad);
			onLoad.setContent(s);
			meta.setOnLoad(onLoad);
		}
		
		s = json.optString(JSONConstants.FORM_ONCLOSE);
		if( s != null ) {
			MetaBaseScript onClose = new MetaBaseScript(MetaConstants.Event_OnClose);
			onClose.setContent(s);
			meta.setOnClose(onClose);
		}
		
		s = json.optString(JSONConstants.FORM_POSRSHOW);
		if( s != null ) {
			MetaBaseScript postShow = new MetaBaseScript(MetaConstants.Event_OnPostShow);
			postShow.setContent(s);
			meta.setOnPostShow(postShow);
		}
		
		meta.setAuthenticate(json.optBoolean(JSONConstants.FORM_AUTHENTICATE));
		meta.setInitFocus(json.optBoolean(JSONConstants.FORM_INITFOCUS));
		meta.setDimValueProvider(json.optString(JSONConstants.FORM_DIMVALUEPROVIDER));
		meta.setUseVariant(json.optBoolean(JSONConstants.FORM_USEVARIANT));
		
		o = json.optJSONObject(JSONConstants.FORM_VARIANT);
		if( o != null ) {
			MetaVariant variant = UIJSONHandlerUtil.unbuild(MetaVariant.class, o);
			meta.setVariant(variant);
		}
		
		array = json.optJSONArray(JSONConstants.FORM_EXTENDCOLLECTION);
		if( array != null ) {
			MetaExtendCollection extendCollection = new MetaExtendCollection();
			extendCollection.addAll(0, UIJSONHandlerUtil.unbuild(MetaExtend.class, array));
			meta.setExtendCollection(extendCollection);
		}
		
		array = json.optJSONArray(JSONConstants.FORM_MACROCOLLECTION);
		if( array != null ) {
			MetaMacroCollection macroCollection = new MetaMacroCollection();
			macroCollection.addAll(UIJSONHandlerUtil.unbuild(MetaMacro.class, array));
			meta.setMacroCollection(macroCollection);
		}
		
		array = json.optJSONArray(JSONConstants.FORM_TIMERTASKCOLLECTION);
		if( array != null ) {
			MetaTimerTaskCollection taskCollection = new MetaTimerTaskCollection();
			taskCollection.addAll(0, UIJSONHandlerUtil.unbuild(MetaTimerTask.class, array));
			meta.setTimerTaskCollection(taskCollection);
		}
		
		meta.setResource(json.optString(JSONConstants.FORM_RESOURCE));
		meta.setExtend(json.optString(JSONConstants.FORM_EXTEND));
		meta.setViewKey(json.optString(JSONConstants.FORM_VIEWKEY));
		meta.setLinkedFormKey(json.optString(JSONConstants.FORM_LINKEDVIEWKEY));
		meta.setDescription(json.optString(JSONConstants.FORM_DESCRIPTION));
		meta.setScreenOrientation(json.optInt(JSONConstants.FORM_ORIENTATION));
		meta.setConfirmClose(json.optBoolean(JSONConstants.FORM_CONFIRMCLOSE));
		
		o = json.optJSONObject(JSONConstants.FORM_NAVIGATION);
		if( o != null ) {
			MetaNavigationBar navigationBar = UIJSONHandlerUtil.unbuild(MetaNavigationBar.class, o);
			meta.setNavigation(navigationBar);
		}
		
		array = json.optJSONArray(JSONConstants.FORM_EVENTHANDLERCOLLECTION);
		if( array != null ) {
			MetaEventHandlerCollection eHandlerCollection = new MetaEventHandlerCollection();
			eHandlerCollection.addAll(UIJSONHandlerUtil.unbuild(MetaEventHandler.class, array));
			meta.setEventHandlerCollection(eHandlerCollection);
		}

		array = json.optJSONArray(JSONConstants.FORM_CALCEXPRCOLLECTION);
		if( array != null ) {
			MetaUICalcExprCollection exprCollection = new MetaUICalcExprCollection();
			exprCollection.addAll(0, UIJSONHandlerUtil.unbuild(MetaUICalcExpr.class, array));
			meta.setCalcExprCollection(exprCollection);
		}
		
		meta.setHasNavigationBar(json.optString(JSONConstants.FORM_HASNAVIAGTION));
		Object fullScreenType = json.opt(JSONConstants.FORM_FULLSCREENTYPE);
		if(fullScreenType != null){
			meta.setFullScreenType(Integer.parseInt(fullScreenType.toString()));
		}
		meta.setAnimationType(json.optString(JSONConstants.FORM_ANIM));
		
		Boolean disableKeyboard = (Boolean) json.opt(JSONConstants.FORM_DISABLEKEYBOARD);
		if( disableKeyboard != null ) {
			meta.setDisableKeyboard(disableKeyboard);
		}
		
		array = json.optJSONArray(JSONConstants.FORM_ANIMCOLLECTION);
		if( array != null ) {
			MetaAnimCollection animCollection = new MetaAnimCollection();
			animCollection.addAll(UIJSONHandlerUtil.unbuild(MetaAnimItem.class, array));
			meta.setAnimCollection(animCollection);
		}	
		
		meta.setVersion(json.optInt(JSONConstants.FORM_VERSION));
		meta.setUserData(json.optString(JSONConstants.FORM_USERDATA));
		meta.setStatusBarColor(json.optString(JSONConstants.FORM_STATUS_BAR_COLOR));
		meta.setOffLine(json.optBoolean(JSONConstants.FORM_OFFLINE));		
		
		array = json.optJSONArray(JSONConstants.FORM_PROMPTIMAGES);
		if(array != null){
			ArrayList<String> promptImages = new ArrayList<>();
			for(int i=0;i<array.length();i++){
				String promptImage = array.optString(i);
				promptImages.add(promptImage);
			}
			meta.setPromptImages(promptImages);
		}
		
		o = json.optJSONObject(JSONConstants.FORM_CELLTYPEGROUP);
		if( o != null ) {
			MetaCellTypeGroup group = UIJSONHandlerUtil.unbuild(MetaCellTypeGroup.class, o);
			meta.setTypeGroup(group);
		}
		
		o = json.optJSONObject(JSONConstants.FORM_WATERMARK);
		if( o != null ) {
			MetaWatermark watermark = UIJSONHandlerUtil.unbuild(MetaWatermark.class, o);
			meta.setWatermark(watermark);
		}
		meta.setSourceForm(json.optString(JSONConstants.FORM_SOURCEFORM));
	} 

	@Override
	public void toJSONImpl(JSONObject json, MetaForm meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_ALIASKEY, meta.getAliasKey());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_TEMPLATEKEY, meta.getTemplateKey());
		
		String caption = hook.getCaptionString(GroupKeyTable.STR_UI, "", meta.getKey(), meta.getCaption(), meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
				
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PROJECTKEY, meta.getProject().getKey());
		
		JSONHelper.writeToJSON(json, JSONConstants.FORM_FORMULACAPTION, meta.getFormulaCaption());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_FORMULAABBRCAPTION, meta.getFormulaAbbrCaption());
		
		String abbrCaption = hook.getString(GroupKeyTable.STR_UI, "", meta.getKey()+"-Abbr",  meta.getAbbrCaption());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_ABBRCAPTION, abbrCaption);
		JSONHelper.writeToJSON(json, JSONConstants.FORM_INITSTATE, meta.getInitState());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getFormType());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_PLATFORM, meta.getPlatform());
		
		// 只序列化客户端属性
		MetaDataSource dataSource = meta.getDataSource();
		if( dataSource != null ) {
			JSONObject o = UIJSONHandlerUtil.build(dataSource,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_DATASOURCE, o);
		}
		JSONObject paras = new JSONObject();
		JSONArray items = new JSONArray();
		paras.put(JSONConstants.COMMON_ITEMS, items);
		json.put(JSONConstants.FORM_PARAMETERS, paras);
		MetaOperationCollection operationCollection = meta.getOperationCollection();
		if( operationCollection != null ) {
			JSONObject o = UIJSONHandlerUtil.build(operationCollection,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_OPERATIONCOLLECTION, o);
		}
		
		MetaScriptCollection scriptCollection = MetaUtil.getScriptCollection(hook.getVE().getMetaFactory(),meta);
		if( scriptCollection != null ) {
			JSONObject o = UIJSONHandlerUtil.build(scriptCollection,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_SCRIPTCOLLECTION, o);
		}
		
		MetaKeyHandlerCollection keyHandlerCollection = meta.getKeyHandlerCollection();
		if( keyHandlerCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, keyHandlerCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_KEYHANDLERCOLLECTION, array);
		}
		
		MetaUICheckRuleCollection uiCheckRuleCollection = meta.getUICheckRuleCollection();
		if( uiCheckRuleCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, uiCheckRuleCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_UICHECKRULECOLLECTION, array);
		}
		
		MetaFormParaCollection formParaCollection = meta.getFormParaCollection();
		if( formParaCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, formParaCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_PARACOLLECTION, array);
		}
		
		MetaBody metaBody = meta.getMetaBody();
		if( metaBody != null ) {
			JSONObject o = UIJSONHandlerUtil.build(metaBody,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_BODY, o);
		}
				
		MetaBaseScript onLoad = meta.getOnLoad();
		if( onLoad != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_ONLOAD, onLoad.getContent().trim());
		}
		
		MetaBaseScript onClose = meta.getOnClose();
		if( onClose != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_ONCLOSE, onClose.getContent().trim());
		}
		
		MetaBaseScript onPostShow = meta.getOnPostShow();
		if ( onPostShow != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_POSRSHOW, onPostShow.getContent().trim());
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.FORM_AUTHENTICATE, meta.isAuthenticate());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_INITFOCUS, meta.initFocus());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_DIMVALUEPROVIDER, meta.getDimValueProvider());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_USEVARIANT, meta.isUseVariant());
		
		MetaVariant variant = meta.getVariant();
		if( variant != null ) {
			JSONObject o = UIJSONHandlerUtil.build(variant,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_VARIANT, o);
		}
		
		MetaExtendCollection extendCollection = meta.getExtendCollection();
		if( extendCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, extendCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_EXTENDCOLLECTION, array);
		}
		
		MetaMacroCollection macroCollection = meta.getMacroCollection();
		if( macroCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, macroCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_MACROCOLLECTION, array);
		}
		
		MetaTimerTaskCollection timerTaskCollection = meta.getTimerTaskCollection();
		if( timerTaskCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, timerTaskCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_TIMERTASKCOLLECTION, array);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.FORM_RESOURCE, meta.getResource());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_EXTEND, meta.getExtend());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_MERGETOSOURCE, hook.getMetaForm().getMergeToSource());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_VIEWKEY, meta.getViewKey());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_LINKEDVIEWKEY, meta.getLinkedFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_DESCRIPTION, meta.getDescription());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_ORIENTATION, meta.getScreenOrientation());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_CONFIRMCLOSE , meta.isConfirmClose());
		
		MetaNavigationBar navigation = meta.getMetaNavigation();
		if( navigation != null ) {
			JSONObject o = UIJSONHandlerUtil.build(navigation,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_NAVIGATION, o);
		}
		
		MetaEventHandlerCollection eventHandlerCollection = meta.getEventHandlerCollection();
		if( eventHandlerCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, eventHandlerCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_EVENTHANDLERCOLLECTION, array);
		}
		
		MetaUICalcExprCollection calcExprCollection = meta.getCalcExprCollection();
		if( calcExprCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, calcExprCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_CALCEXPRCOLLECTION, array);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.FORM_HASNAVIAGTION , meta.isHasNavigationBar());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_FULLSCREENTYPE , meta.getFullScreenType());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_ANIM, meta.getAnimationType());
		
		Boolean disableKeyboard = meta.isDisableKeyboard();
		if( disableKeyboard != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_DISABLEKEYBOARD, disableKeyboard);			
		}
		
		MetaAnimCollection animCollection = meta.getAnimCollection();
		if( animCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, animCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_ANIMCOLLECTION, array);
		} 
		
		JSONHelper.writeToJSON(json, JSONConstants.FORM_VERSION, meta.getVersion());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_USERDATA, meta.getUserData());		
		JSONHelper.writeToJSON(json, JSONConstants.FORM_STATUS_BAR_COLOR, meta.getStatusBarColor());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_OFFLINE, meta.isOffLine());
		
		MetaCellTypeTable table = hook.getVE().getMetaFactory().getCellTypeTable();
		MetaCellTypeGroup typeGroup = table.get(hook.getFormKey());
		if( typeGroup != null ) {
			JSONObject o = UIJSONHandlerUtil.build(typeGroup,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_CELLTYPEGROUP, o);
		}
		
		JSONArray promptImageArray = new JSONArray();
		for (int i = 0; i < meta.getPromptImages().size(); i++) {
			promptImageArray.put(meta.getPromptImages().get(i));
		}
		json.put(JSONConstants.FORM_PROMPTIMAGES, promptImageArray);
		
		MetaWatermark watermark = meta.getWatermark();
		if( watermark != null ) {
			JSONObject o = UIJSONHandlerUtil.build(watermark,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_WATERMARK, o);
		}

		if (meta.getSourceForm() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.FORM_SOURCEFORM, meta.getSourceForm());
		}
	}

	@Override
	public MetaForm newInstance() {
		return new MetaForm();
	}

}
