/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.util;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaMove;
import com.bokesoft.yigo.meta.diff.impl.IDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElement;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMetaObjectCompare;
import com.bokesoft.yigo.meta.diff.util.DefaultMetaObjectComparer;
import java.util.List;

public class MetaDiffUtil {
    private static IMetaObjectCompare<AbstractMetaObject> diffComparer = new DefaultMetaObjectComparer();

    public static void diffOnlyUpdate(AbstractMetaObject oldMeta, AbstractMetaObject newMeta, MetaDiffNode metaDiffNode, IDiffMetaEnv env) {
        if (oldMeta == newMeta) {
            return;
        }
        if (oldMeta == null && newMeta != null) {
            metaDiffNode.recordUpdate(newMeta.clone());
            return;
        }
        if (newMeta == null && oldMeta != null) {
            newMeta = oldMeta.newInstance();
        }
        if (!MetaDiffUtil.isEqualTo(oldMeta, newMeta, env)) {
            metaDiffNode.recordUpdate(newMeta.clone());
        }
    }

    public static <T extends KeyPairMetaObject> void removeFromCollection(String key, GenericNoKeyCollection<T> collection) {
        if (key != null && collection != null) {
            for (KeyPairMetaObject item : collection) {
                if (!key.equals(item.getKey())) continue;
                collection.remove((AbstractMetaObject)item);
                return;
            }
        }
    }

    public static <T extends KeyPairMetaObject> void removeFromCollection(String key, GenericKeyCollection<T> collection) {
        if (key != null && collection != null) {
            for (KeyPairMetaObject item : collection) {
                if (!key.equals(item.getKey())) continue;
                collection.remove(item.getKey());
                return;
            }
        }
    }

    public static <T extends KeyPairMetaObject> void removeFromCollection(String key, List<T> collection) {
        if (key != null && collection != null) {
            for (KeyPairMetaObject item : collection) {
                if (!key.equals(item.getKey())) continue;
                collection.remove(item);
                return;
            }
        }
    }

    public static void diffKeyPairCollection(IKeyPairElements<IKeyPairElement<?>> oldElements, IKeyPairElements<IKeyPairElement<?>> newElements, MetaDiffNode metaDiffNode, MetaDiff metaDiff, AbstractMetaObject parent, AbstractMetaObject grandParent, IDiffContext context) throws Exception {
        String parentTag = parent == null ? "" : parent.getTagName();
        for (IKeyPairElement<?> newElement : newElements.getElementsList()) {
            if (oldElements.containsKey(newElement.getKey(), newElement.getTagName())) continue;
            metaDiffNode.recordAdd(newElement.getKey(), newElement.getPreviousKey(), parentTag, newElement.getContainerKey(), newElement.getMeta());
            MetaMove metaMove = MetaMove.create((String)newElement.getKey(), (String)newElement.getTagName(), (String)parentTag, (String)newElement.getContainerKey(), (String)newElement.getPreviousKey());
            metaDiffNode.recordMove(metaMove);
        }
        for (IKeyPairElement<?> oldElement : oldElements.getElementsList()) {
            String key = oldElement.getKey();
            IKeyPairElement<?> newElement = newElements.getElement(key, oldElement.getTagName());
            if (!newElements.containsKey(key, oldElement.getTagName())) {
                metaDiffNode.recordDelete(oldElement.getKey(), oldElement.getMeta(), parent);
                continue;
            }
            if (!oldElement.getPreviousKey().equals(newElement.getPreviousKey()) || !oldElement.getContainerKey().equals(newElement.getContainerKey())) {
                MetaMove metaMove = MetaMove.create((String)newElement.getKey(), (String)newElement.getTagName(), (String)parentTag, (String)newElement.getContainerKey(), (String)newElement.getPreviousKey());
                metaDiffNode.recordMove(metaMove);
                MetaDiffUtil.divideDiffKeyMeta(key, oldElement.getMeta(), newElement.getMeta(), metaDiff, parent, grandParent, context);
                continue;
            }
            MetaDiffUtil.divideDiffKeyMeta(key, oldElement.getMeta(), newElement.getMeta(), metaDiff, parent, grandParent, context);
        }
    }

    public static void divideDiffKeyMeta(String key, AbstractMetaObject oldMeta, AbstractMetaObject newMeta, MetaDiff metaDiff, AbstractMetaObject parent, AbstractMetaObject grandParent, IDiffContext context) throws Exception {
        IDiffAction action = context.getDiffAction(oldMeta);
        if (action != null) {
            action.doDivide(key, oldMeta, newMeta, metaDiff, parent, grandParent, context);
        }
    }

    public static void diffKeyPairObject(KeyPairMetaObject oldMeta, KeyPairMetaObject newMeta, MetaDiffNode metaDiffNode, MetaDiff metaDiff, AbstractMetaObject parent, IDiffContext context) throws Exception {
        if (oldMeta == null && newMeta != null) {
            metaDiffNode.recordAdd(newMeta);
            return;
        }
        if (oldMeta != null && newMeta == null) {
            metaDiffNode.recordDelete(oldMeta, parent);
            return;
        }
        if (!oldMeta.getKey().equalsIgnoreCase(newMeta.getKey())) {
            metaDiffNode.recordDelete(oldMeta, parent);
            metaDiffNode.recordAdd(newMeta);
        } else {
            MetaDiffUtil.divideDiffKeyMeta(oldMeta.getKey(), (AbstractMetaObject)oldMeta, (AbstractMetaObject)newMeta, metaDiff, parent, null, context);
        }
    }

    public static boolean isEqualTo(AbstractMetaObject srcMetaObj, AbstractMetaObject tgtMetaObj, IDiffMetaEnv env) {
        return diffComparer.equal(srcMetaObj, tgtMetaObj, env);
    }
}

