/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.util;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DiffMetaDomUtil {
    public static final String ATTR_DELETE = "###DELETE###";

    public static String trans2XmlDeep(AbstractMetaObject meta, IDiffMetaEnv env) throws Exception {
        Document document = DiffMetaDomUtil.trans2DocumentDeep(meta, env);
        return DomHelper.toString((Document)document);
    }

    public static Document trans2DocumentDeep(AbstractMetaObject meta, IDiffMetaEnv env) throws Exception {
        return env.saveAsDocument(meta);
    }

    public static Document trans2DocumentSingle(AbstractMetaObject meta, IMetaEnv env) throws Exception {
        Document document = DomHelper.createDocument();
        Element rootElement = document.createElement(meta.getTagName());
        document.appendChild(rootElement);
        meta.traversalSingle(env, (Object)document, (Object)rootElement, (Object)true, 2);
        return document;
    }

    public static void mergeElementAttrs(Element baseElem, Element diffElem, MetaDiffNode metaDiffNode) {
        if (diffElem != null) {
            NamedNodeMap diffAttrNameMap = diffElem.getAttributes();
            Node diffAttrNode = null;
            String diffAttrName = null;
            String diffAttrValue = null;
            for (int index = 0; index < diffAttrNameMap.getLength(); ++index) {
                diffAttrNode = diffAttrNameMap.item(index);
                diffAttrName = diffAttrNode.getNodeName();
                diffAttrValue = diffAttrNode.getNodeValue();
                baseElem.setAttribute(diffAttrName, diffAttrValue);
            }
            for (String deleteStr : metaDiffNode.getDeleteAttrList()) {
                baseElem.removeAttribute(deleteStr);
            }
        }
    }

    public static void diffElementAttrs(Element oldElem, Element curElem, Element diffElement, MetaDiffNode metaDiffNode) {
        int index;
        NamedNodeMap oldAttrNameMap = oldElem.getAttributes();
        NamedNodeMap curAttrNameMap = curElem.getAttributes();
        Node oldAttrNode = null;
        Node curAttrNode = null;
        String curAttrName = null;
        String curAttrValue = null;
        String oldAttrName = null;
        String oldAttrValue = null;
        for (index = 0; index < oldAttrNameMap.getLength(); ++index) {
            oldAttrNode = oldAttrNameMap.item(index);
            oldAttrName = oldAttrNode.getNodeName();
            oldAttrValue = oldAttrNode.getNodeValue();
            if (curElem.hasAttribute(oldAttrName)) {
                curAttrValue = curElem.getAttribute(oldAttrName);
                if (oldAttrValue.equals(curAttrValue)) continue;
                diffElement.setAttribute(oldAttrName, curAttrValue);
                continue;
            }
            metaDiffNode.addDeleteAttr(oldAttrName);
            metaDiffNode.markChanged();
        }
        for (index = 0; index < curAttrNameMap.getLength(); ++index) {
            curAttrNode = curAttrNameMap.item(index);
            curAttrName = curAttrNode.getNodeName();
            curAttrValue = curAttrNode.getNodeValue();
            if (oldElem.hasAttribute(curAttrName)) continue;
            diffElement.setAttribute(curAttrName, curAttrValue);
        }
    }
}

