/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.collection;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaMove;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElement;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class AbstractKeyPairElements<T extends AbstractMetaObject>
implements IKeyPairElements<IKeyPairElement<T>> {
    private Iterator<T> iterator = null;
    protected LinkedHashMap<String, IKeyPairElement<T>> mapElements = new LinkedHashMap();

    public AbstractKeyPairElements(Iterator<T> iterator) {
        this.iterator = iterator;
        this.init();
    }

    protected void init() {
        if (this.iterator == null) {
            return;
        }
        IKeyPairElement<AbstractMetaObject> element = null;
        IKeyPairElement<AbstractMetaObject> privousElement = null;
        while (this.iterator.hasNext()) {
            element = this.createKeyPairElement((AbstractMetaObject)this.iterator.next(), privousElement, null);
            this.mapElements.put(element.getKey(), element);
            if (privousElement != null) {
                privousElement.setNext(element);
            }
            privousElement = element;
        }
    }

    @Override
    public void addElement(MetaAdd metaAdd) {
        AbstractMetaObject meta = metaAdd.getBase();
        IKeyPairElement<AbstractMetaObject> element = this.createKeyPairElement(meta, null, null);
        this.addMeta(metaAdd.getKey(), metaAdd.getBase(), metaAdd.getPreviousKey(), metaAdd.getContainerKey());
        this.mapElements.put(element.getKey(), element);
    }

    @Override
    public void deleteElement(MetaDelete metaDelete) {
        Object element = this.getElement(metaDelete.getKey(), null);
        if (element == null) {
            return;
        }
        IKeyPairElement curPrevious = element.getPrevious();
        IKeyPairElement curNext = element.getNext();
        if (curPrevious != null) {
            curPrevious.setNext(curNext);
        }
        if (curNext != null) {
            curNext.setPrevious(curPrevious);
        }
        this.remove4Collection(element.getMeta());
        this.mapElements.remove(metaDelete.getKey());
    }

    @Override
    public boolean containsKey(String elementKey, String tagName) {
        return this.mapElements.containsKey(elementKey);
    }

    @Override
    public boolean contains(IKeyPairElement<T> element) {
        return this.mapElements.containsKey(element.getKey());
    }

    @Override
    public IKeyPairElement<T> getElement(String elementKey, String tagName) {
        return this.mapElements.get(elementKey);
    }

    @Override
    public Collection<IKeyPairElement<T>> getElementsList() {
        return this.mapElements.values();
    }

    @Override
    public void moveElements(MetaMoveCollection moveCollection) {
        Object element = null;
        ArrayList<String> moves = new ArrayList<String>();
        for (MetaMove move : moveCollection) {
            element = this.getElement(move.getKey(), null);
            if (element == null) continue;
            this.remove4Collection(element.getMeta());
            moves.add(move.getKey());
        }
        int index = 0;
        int maxLoopCount = moves.size();
        while (moves.size() > 0 && maxLoopCount >= 0) {
            MetaMove move = (MetaMove)moveCollection.get((String)moves.get(index));
            while (moves.contains(move.getPreviousKey())) {
                move = (MetaMove)moveCollection.get(move.getPreviousKey());
            }
            element = this.getElement(move.getKey(), null);
            if (element == null || this.addMeta(element.getKey(), element.getMeta(), move.getPreviousKey(), move.getTargetContainerKey())) {
                moves.remove(move.getKey());
            }
            if (index >= moves.size() - 1) {
                --maxLoopCount;
                index = 0;
                continue;
            }
            ++index;
        }
    }

    protected boolean addMeta(String key, T meta, String previousKey, String containerKey) {
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> itr = this.iteratorMeta();
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        this.removeSourceIfExisted(key, list);
        if (StringUtil.isBlankOrNull((String)previousKey)) {
            list.add(0, meta);
        } else {
            Object preElement = this.getElement(previousKey, null);
            if (preElement == null) {
                list.add(meta);
            } else {
                int preIndex = list.indexOf(preElement.getMeta());
                if (preIndex == -1) {
                    return false;
                }
                list.add(preIndex + 1, meta);
            }
        }
        this.clearCollection();
        for (AbstractMetaObject tmp : list) {
            this.add4Collection(tmp);
        }
        return true;
    }

    protected void removeSourceIfExisted(String key) {
        Object sourceElement = this.getElement(key, null);
        if (sourceElement != null) {
            this.remove4Collection(sourceElement.getMeta());
        }
    }

    protected void removeSourceIfExisted(String key, List<T> list) {
        IKeyPairElement<T> element = this.mapElements.get(key);
        if (element != null) {
            list.remove(element.getMeta());
        }
    }

    protected abstract IKeyPairElement<T> createKeyPairElement(T var1, IKeyPairElement<T> var2, IKeyPairElement<T> var3);

    protected abstract void remove4Collection(T var1);

    protected abstract void clearCollection();

    protected abstract void add4Collection(T var1);

    protected abstract Iterator<T> iteratorMeta();
}

