/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.base;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaObjectCreator;
import com.bokesoft.yigo.meta.diff.util.DiffMetaDomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultDiffMetaObjectCreator
implements IDiffMetaObjectCreator<AbstractMetaObject> {
    @Override
    public AbstractMetaObject createBaseDiffMeta(String key, AbstractMetaObject oldMeta, AbstractMetaObject newMeta, MetaDiffNode diffNode, IMetaEnv env) throws Exception {
        Document oldDoc = DiffMetaDomUtil.trans2DocumentSingle(oldMeta, env);
        Document newDoc = DiffMetaDomUtil.trans2DocumentSingle(newMeta, env);
        AbstractMetaObject meta = newMeta.newInstance();
        Element oldElem = oldDoc.getDocumentElement();
        Element curElem = newDoc.getDocumentElement();
        Element diffElement = newDoc.createElement(curElem.getTagName());
        DiffMetaDomUtil.diffElementAttrs(oldElem, curElem, diffElement, diffNode);
        if (diffElement.getAttributes().getLength() > 0) {
            diffNode.markChanged();
        }
        if (!StringUtil.isBlankOrNull((String)key)) {
            diffElement.setAttribute("Key", key);
        }
        if (oldElem.hasAttribute("CellType")) {
            String oldCellType = oldElem.getAttribute("CellType");
            String curCellType = curElem.getAttribute("CellType");
            if (oldCellType != null && !oldCellType.equalsIgnoreCase(curCellType)) {
                throw new Exception("Unsupport CellType Change: CellKey = " + key);
            }
            diffElement.setAttribute("CellType", oldElem.getAttribute("CellType"));
        }
        if (oldElem.hasAttribute("ColumnType")) {
            String oldColumnType = oldElem.getAttribute("ColumnType");
            String curColumnType = curElem.getAttribute("ColumnType");
            if (oldColumnType != null && !oldColumnType.equalsIgnoreCase(curColumnType)) {
                throw new Exception("Unsupport ColumnType Change: ColumnKey = " + key);
            }
            diffElement.setAttribute("ColumnType", oldColumnType);
        }
        meta.traversalSingle(env, (Object)newDoc, (Object)diffElement, (Object)false, 2);
        return meta;
    }
}

