/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.form;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.action.AbstractMetaDiffAction;
import com.bokesoft.yigo.meta.diff.action.form.MetaPropertyDiffUtil;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.treeview.MetaTreeViewColumn;

public class MetaTreeViewColumnDiffAction
extends AbstractMetaDiffAction<MetaTreeViewColumn> {
    @Override
    public boolean mergeDiffNode(final MetaTreeViewColumn baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                int cellType = baseMeta.getColumnType();
                switch (meta.getTagName()) {
                    case "OnClick": {
                        if (cellType == 200) {
                            ((MetaButtonProperties)baseMeta.getProperties()).setOnClick((MetaBaseScript)meta.clone());
                            break;
                        }
                        if (cellType != 208) break;
                        ((MetaHyperLinkProperties)baseMeta.getProperties()).setOnClick((MetaBaseScript)meta.clone());
                        break;
                    }
                    case "OnFocus": {
                        if (cellType == 215) {
                            ((MetaTextEditorProperties)baseMeta.getProperties()).setOnFocus((MetaBaseScript)meta.clone());
                            break;
                        }
                        if (cellType != 210) break;
                        ((MetaNumberEditorProperties)baseMeta.getProperties()).setOnFocus((MetaBaseScript)meta.clone());
                        break;
                    }
                    case "KeyEnter": {
                        if (cellType != 215) break;
                        ((MetaTextEditorProperties)baseMeta.getProperties()).setKeyEnter((MetaBaseScript)meta.clone());
                        break;
                    }
                    case "ItemFilterCollection": {
                        MetaItemFilterCollection filterCollection = MetaPropertyDiffUtil.cloneDictItemFilter((MetaItemFilterCollection)meta);
                        ((MetaDictProperties)baseMeta.getProperties()).setFilters(filterCollection);
                    }
                }
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaTreeViewColumn oldMeta, MetaTreeViewColumn newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        switch (oldMeta.getColumnType()) {
            case 208: {
                MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)((MetaHyperLinkProperties)oldMeta.getProperties()).getOnClick(), (AbstractMetaObject)((MetaHyperLinkProperties)newMeta.getProperties()).getOnClick(), diffNode, (IDiffMetaEnv)context.getEnv());
                break;
            }
            case 200: {
                MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)((MetaButtonProperties)oldMeta.getProperties()).getOnClick(), (AbstractMetaObject)((MetaButtonProperties)newMeta.getProperties()).getOnClick(), diffNode, (IDiffMetaEnv)context.getEnv());
                break;
            }
            case 206: {
                MetaItemFilterCollection oldFilters = ((MetaDictProperties)oldMeta.getProperties()).getFilters();
                MetaItemFilterCollection newFilters = ((MetaDictProperties)newMeta.getProperties()).getFilters();
                MetaPropertyDiffUtil.divideDictFiltersNode(oldFilters, newFilters, diffNode, (IDiffMetaEnv)context.getEnv());
                break;
            }
            case 210: {
                MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)((MetaNumberEditorProperties)oldMeta.getProperties()).getOnFocus(), (AbstractMetaObject)((MetaNumberEditorProperties)newMeta.getProperties()).getOnFocus(), diffNode, (IDiffMetaEnv)context.getEnv());
                break;
            }
            case 215: {
                MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)((MetaTextEditorProperties)oldMeta.getProperties()).getOnFocus(), (AbstractMetaObject)((MetaTextEditorProperties)newMeta.getProperties()).getOnFocus(), diffNode, (IDiffMetaEnv)context.getEnv());
                MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)((MetaTextEditorProperties)oldMeta.getProperties()).getKeyEnter(), (AbstractMetaObject)((MetaTextEditorProperties)newMeta.getProperties()).getKeyEnter(), diffNode, (IDiffMetaEnv)context.getEnv());
            }
        }
    }
}

