/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.form;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.action.form.MetaComponentDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;
import com.bokesoft.yigo.meta.form.component.control.MetaSplitButton;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItemCollection;

public class MetaSplitButtonDiffAction
extends MetaComponentDiffAction<MetaSplitButton> {
    @Override
    public boolean mergeDiffNode(final MetaSplitButton baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        super.mergeDiffNode(baseMeta, metaDiff, metaDiffNode, context);
        final IKeyPairElements itemsAll = CollectionUtil.trans2KeyPairElements(baseMeta.getItemCollection());
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "OnClick": {
                        baseMeta.setOnClick((MetaBaseScript)meta.clone());
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                MetaDiffUtil.removeFromCollection(meta.getKey(), baseMeta.getItemCollection());
            }

            public void mergeAdd(MetaAdd meta) {
                if (meta.getBase() instanceof MetaDropdownItem) {
                    if (baseMeta.getItemCollection() == null) {
                        baseMeta.setItemCollection(new MetaDropdownItemCollection());
                    }
                    baseMeta.getItemCollection().add((AbstractMetaObject)((MetaDropdownItem)meta.getBase().clone()));
                }
            }

            public boolean mergeMoveCollection(MetaMoveCollection moveCollection) {
                itemsAll.moveElements(moveCollection);
                return true;
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaSplitButton oldMeta, MetaSplitButton newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        super.divideSubNode(oldMeta, newMeta, oldParent, diffNode, metaDiff, context);
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getOnClick(), (AbstractMetaObject)newMeta.getOnClick(), diffNode, (IDiffMetaEnv)context.getEnv());
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getItemCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getItemCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getItemCollection(), (AbstractMetaObject)oldMeta, context);
    }
}

