/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.form;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.action.form.MetaComponentDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;
import com.bokesoft.yigo.meta.form.component.control.MetaSegmentedControl;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;

public class MetaSegmentedControlDiffAction
extends MetaComponentDiffAction<MetaSegmentedControl> {
    @Override
    public boolean mergeDiffNode(final MetaSegmentedControl baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        super.mergeDiffNode(baseMeta, metaDiff, metaDiffNode, context);
        final IKeyPairElements items = CollectionUtil.trans2KeyPairElements(baseMeta.getItems());
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "FormulaItems": {
                        baseMeta.setFormulaItems((MetaBaseScript)meta.clone());
                        break;
                    }
                    case "ListBoxItemCollection": {
                        baseMeta.setItems((MetaListBoxItemCollection)meta.clone());
                        break;
                    }
                    case "QueryDef": {
                        baseMeta.setQueryDef((MetaQueryDef)meta.clone());
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                switch (meta.getDeleteTag()) {
                    case "Item": {
                        items.deleteElement(meta);
                    }
                }
            }

            public void mergeAdd(MetaAdd meta) {
                switch (meta.getContainerTag()) {
                    case "ListBoxItemCollection": {
                        items.addElement(meta);
                    }
                }
            }

            public boolean mergeMoveCollection(MetaMoveCollection moveCollection) {
                items.moveElements(MetaMoveCollection.filterMoveCollectionByTags((MetaMoveCollection)moveCollection, (String[])new String[]{"Item"}));
                return true;
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaSegmentedControl oldMeta, MetaSegmentedControl newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        super.divideSubNode(oldMeta, newMeta, oldParent, diffNode, metaDiff, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getItems()), CollectionUtil.trans2KeyPairElements(newMeta.getItems()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getItems(), (AbstractMetaObject)oldMeta, context);
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getFormulaItems(), (AbstractMetaObject)newMeta.getFormulaItems(), diffNode, (IDiffMetaEnv)context.getEnv());
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getQueryDef(), (AbstractMetaObject)newMeta.getQueryDef(), diffNode, (IDiffMetaEnv)context.getEnv());
    }
}

