/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.form;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.action.form.MetaComponentDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;
import com.bokesoft.yigo.meta.form.component.control.MetaImageList;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;

public class MetaImageListDiffAction
extends MetaComponentDiffAction<MetaImageList> {
    @Override
    public boolean mergeDiffNode(final MetaImageList baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        super.mergeDiffNode(baseMeta, metaDiff, metaDiffNode, context);
        final IKeyPairElements imageItemAll = CollectionUtil.trans2KeyPairElements(baseMeta.getProperties());
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "OnClick": {
                        baseMeta.setOnClick((MetaBaseScript)meta.clone());
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                imageItemAll.deleteElement(meta);
            }

            public void mergeAdd(MetaAdd metaAdd) {
                imageItemAll.addElement(metaAdd);
            }

            public boolean mergeMoveCollection(MetaMoveCollection moveCollection) {
                imageItemAll.moveElements(moveCollection);
                return true;
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaImageList oldMeta, MetaImageList newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        super.divideSubNode(oldMeta, newMeta, oldParent, diffNode, metaDiff, context);
        MetaImageListProperties oldImageItems = (MetaImageListProperties)oldMeta.getProperties();
        MetaImageListProperties newImageItems = (MetaImageListProperties)newMeta.getProperties();
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldImageItems), CollectionUtil.trans2KeyPairElements(newImageItems), diffNode, metaDiff, (AbstractMetaObject)oldMeta, oldParent, context);
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getOnClick(), (AbstractMetaObject)newMeta.getOnClick(), diffNode, (IDiffMetaEnv)context.getEnv());
    }
}

