/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.dataobject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableFilter;
import com.bokesoft.yigo.meta.dataobject.MetaTableSourceCollection;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.action.AbstractMetaDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;

public class MetaTableDiffAction
extends AbstractMetaDiffAction<MetaTable> {
    @Override
    public boolean mergeDiffNode(final MetaTable baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        final IKeyPairElements parameterCollection = CollectionUtil.trans2KeyPairElements(baseMeta.getParameterCollection());
        final IKeyPairElements sourceCollection = CollectionUtil.trans2KeyPairElements(baseMeta.getSourceCollection());
        final IKeyPairElements indexCollection = CollectionUtil.trans2KeyPairElements(baseMeta.getIndexCollection());
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "TableFilter": {
                        baseMeta.setFilter((MetaTableFilter)meta.clone());
                        break;
                    }
                    case "ParameterCollection": {
                        baseMeta.setParameterCollection((MetaParameterCollection)meta.clone());
                        break;
                    }
                    case "TableSourceCollection": {
                        baseMeta.setSourceCollection((MetaTableSourceCollection)meta.clone());
                        break;
                    }
                    case "Statement": {
                        baseMeta.setStatement((MetaStatement)meta.clone());
                        break;
                    }
                    case "IndexCollection": {
                        baseMeta.setIndexCollection((MetaIndexCollection)meta.clone());
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                switch (meta.getParentTag()) {
                    case "ParameterCollection": {
                        parameterCollection.deleteElement(meta);
                        return;
                    }
                    case "TableSourceCollection": {
                        sourceCollection.deleteElement(meta);
                        return;
                    }
                    case "IndexCollection": {
                        indexCollection.deleteElement(meta);
                        return;
                    }
                }
                baseMeta.remove(meta.getKey());
            }

            public void mergeAdd(MetaAdd meta) {
                switch (meta.getContainerTag()) {
                    case "ParameterCollection": {
                        parameterCollection.addElement(meta);
                        return;
                    }
                    case "TableSourceCollection": {
                        sourceCollection.addElement(meta);
                        return;
                    }
                    case "IndexCollection": {
                        indexCollection.addElement(meta);
                        return;
                    }
                }
                if (meta.getBase() instanceof MetaColumn) {
                    baseMeta.add((KeyPairMetaObject)((MetaColumn)meta.getBase()));
                }
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaTable oldMeta, MetaTable newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta), CollectionUtil.trans2KeyPairElements(newMeta), diffNode, metaDiff, (AbstractMetaObject)oldMeta, null, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getParameterCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getParameterCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getParameterCollection(), (AbstractMetaObject)oldMeta, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getSourceCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getSourceCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getSourceCollection(), (AbstractMetaObject)oldMeta, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getIndexCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getIndexCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getIndexCollection(), (AbstractMetaObject)oldMeta, context);
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getFilter(), (AbstractMetaObject)newMeta.getFilter(), diffNode, (IDiffMetaEnv)context.getEnv());
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getStatement(), (AbstractMetaObject)newMeta.getStatement(), diffNode, (IDiffMetaEnv)context.getEnv());
    }
}

