/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.datamigration;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTable;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTableCollection;
import com.bokesoft.yigo.meta.datamigration.MetaDMTargetTable;
import com.bokesoft.yigo.meta.datamigration.MetaDMTargetTableCollection;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.error.MetaDataMigrationErrorInfo;
import com.bokesoft.yigo.meta.datamigration.error.MetaDataMigrationErrorInfoCollection;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.action.AbstractMetaDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;

public class MetaDataMigrationDiffAction
extends AbstractMetaDiffAction<MetaDataMigration> {
    @Override
    public boolean mergeDiffNode(final MetaDataMigration baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        final IKeyPairElements allFields = CollectionUtil.trans2KeyPairElements(baseMeta.getTargetTableCollection());
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "TargetTableCollection": {
                        baseMeta.setTargetTableCollection((MetaDMTargetTableCollection)meta.clone());
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                String key = meta.getKey();
                switch (meta.getDeleteTag()) {
                    case "SourceTable": {
                        baseMeta.getSourceTableCollection().remove(key);
                        break;
                    }
                    case "ErrorInfo": {
                        baseMeta.getErrorInfoCollection().remove(key);
                        break;
                    }
                    case "TargetTable": {
                        allFields.deleteElement(meta);
                    }
                }
            }

            public void mergeAdd(MetaAdd meta) {
                AbstractMetaObject metaAdd = meta.getBase();
                if (metaAdd instanceof MetaDMSourceTable) {
                    if (baseMeta.getSourceTableCollection() == null) {
                        baseMeta.setSourceTableCollection(new MetaDMSourceTableCollection());
                    }
                    baseMeta.getSourceTableCollection().add((KeyPairMetaObject)((MetaDMSourceTable)metaAdd));
                } else if (metaAdd instanceof MetaDataMigrationErrorInfo) {
                    if (baseMeta.getErrorInfoCollection() == null) {
                        baseMeta.setErrorInfoCollection(new MetaDataMigrationErrorInfoCollection());
                    }
                    baseMeta.getErrorInfoCollection().add((KeyPairMetaObject)((MetaDataMigrationErrorInfo)metaAdd));
                } else if (metaAdd instanceof MetaDMTargetTable) {
                    allFields.addElement(meta);
                }
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaDataMigration oldMeta, MetaDataMigration newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getSourceTableCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getSourceTableCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getSourceTableCollection(), (AbstractMetaObject)oldMeta, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getErrorInfoCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getErrorInfoCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getErrorInfoCollection(), (AbstractMetaObject)oldMeta, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getTargetTableCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getTargetTableCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getTargetTableCollection(), (AbstractMetaObject)oldMeta, context);
    }
}

