/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.datamap;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.action.AbstractMetaDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;

public class MetaSourceTableDiffAction
extends AbstractMetaDiffAction<MetaSourceTable> {
    @Override
    public boolean mergeDiffNode(final MetaSourceTable baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        final IKeyPairElements allFields = CollectionUtil.trans2KeyPairElements(baseMeta);
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "SourceTable": {
                        MetaSourceTable newSourceTable = (MetaSourceTable)meta.clone();
                        baseMeta.clear();
                        for (int i = 0; i < newSourceTable.size(); ++i) {
                            baseMeta.add(newSourceTable.get(i));
                        }
                        break;
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                allFields.deleteElement(meta);
            }

            public void mergeAdd(MetaAdd meta) {
                allFields.addElement(meta);
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaSourceTable oldMeta, MetaSourceTable newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta), CollectionUtil.trans2KeyPairElements(newMeta), diffNode, metaDiff, (AbstractMetaObject)oldMeta, oldParent, context);
    }
}

