/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.base.DefaultDiffMetaObjectCreator;
import com.bokesoft.yigo.meta.diff.factory.AutoKeyElementFactory;
import com.bokesoft.yigo.meta.diff.impl.IDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaObjectCreator;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElement;
import com.bokesoft.yigo.meta.diff.util.DiffMetaDomUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractMetaDiffAction<T extends AbstractMetaObject>
implements IDiffAction<T> {
    private static IDiffMetaObjectCreator<AbstractMetaObject> diffCreator = new DefaultDiffMetaObjectCreator();

    public void doDivide(String key, T oldMeta, T newMeta, MetaDiff metaDiff, AbstractMetaObject oldParent, AbstractMetaObject grandfather, IDiffContext context) throws Exception {
        if (context.getActionMap() == null) {
            return;
        }
        if (!oldMeta.getTagName().equals(newMeta.getTagName())) {
            throw new Exception("unsupport divide " + oldMeta.getTagName() + " with " + newMeta.getTagName());
        }
        MetaDiffNode diffNode = metaDiff.createDiffNodeIfNotExist(key, newMeta, oldParent, grandfather);
        this.divideBaseMeta(key, oldMeta, newMeta, diffNode, (IDiffMetaEnv)context.getEnv());
        this.divideSubNode(oldMeta, newMeta, oldParent, diffNode, metaDiff, context);
        if (diffNode.isChanged()) {
            metaDiff.addDiffNode(diffNode);
        }
    }

    public void doMerge(MetaDiff metaDiff, T baseMeta, AbstractMetaObject parent, AbstractMetaObject grandParent, IDiffContext context) throws Exception {
        if (metaDiff == null) {
            return;
        }
        boolean needContinue = true;
        IKeyPairElement element = baseMeta instanceof KeyPairMetaObject ? null : AutoKeyElementFactory.create(baseMeta, null, null);
        MetaDiffNode metaDiffNode = metaDiff.getDiffNode(element == null ? "" : element.getKey(), baseMeta, parent, grandParent);
        if (metaDiffNode != null) {
            this.mergeBaseDiffMeta(baseMeta, metaDiffNode.getMeta(), metaDiffNode, context.getEnv());
            needContinue = this.mergeDiffNode(baseMeta, metaDiff, metaDiffNode, context);
        } else if (this.canMergeWithoutDiffNode()) {
            needContinue = this.mergeDiffNode(baseMeta, metaDiff, metaDiffNode, context);
        }
        if (needContinue) {
            this.mergeDiffCollectionObjects(baseMeta, parent, metaDiff, context);
            this.mergeDiffChildMetaObjects(baseMeta, parent, metaDiff, context);
        }
    }

    protected void mergeDiffCollectionObjects(T baseMeta, AbstractMetaObject parent, MetaDiff metaDiff, IDiffContext context) throws Exception {
        if (baseMeta instanceof Iterable) {
            Iterator itr = ((Iterable)baseMeta).iterator();
            Object item = null;
            AbstractMetaObject meta = null;
            while (itr.hasNext()) {
                item = itr.next();
                if (!(item instanceof AbstractMetaObject)) continue;
                meta = item;
                IDiffAction action = context.getActionMap().getDiffAction(meta);
                if (action == null) continue;
                action.doMerge(metaDiff, meta, baseMeta, parent, context);
            }
        }
    }

    protected void mergeDiffChildMetaObjects(T meta, AbstractMetaObject parent, MetaDiff metaDiff, IDiffContext context) throws Exception {
        LinkedList list = new LinkedList();
        meta.getChildMetaObjects(list);
        Iterator itChild = list.iterator();
        Object childObject = null;
        while (itChild.hasNext()) {
            childObject = itChild.next();
            if (childObject == null) continue;
            if (childObject instanceof AbstractMetaObject) {
                AbstractMetaObject childMetaObject = childObject;
                this.mergeDiffChild(childMetaObject, (AbstractMetaObject)meta, parent, metaDiff, context);
                continue;
            }
            if (!(childObject instanceof Collection)) continue;
            for (Object tmpItem : (Collection)childObject) {
                AbstractMetaObject childMetaObject = (AbstractMetaObject)tmpItem;
                this.mergeDiffChild(childMetaObject, (AbstractMetaObject)meta, parent, metaDiff, context);
            }
        }
    }

    protected void mergeDiffChild(AbstractMetaObject meta, AbstractMetaObject parentMeta, AbstractMetaObject grandfather, MetaDiff metaDiff, IDiffContext context) throws Exception {
        if (context.getActionMap() == null) {
            return;
        }
        IDiffAction action = context.getActionMap().getDiffAction(meta);
        if (action != null) {
            action.doMerge(metaDiff, meta, parentMeta, grandfather, context);
        }
    }

    protected AbstractMetaObject divideBaseMeta(String key, T oldMeta, T newMeta, MetaDiffNode diffNode, IDiffMetaEnv env) throws Exception {
        AbstractMetaObject metaObject = this.createBaseDiffMeta(key, oldMeta, newMeta, diffNode, env);
        diffNode.setBase(metaObject);
        return metaObject;
    }

    protected void doDivideSub(String key, AbstractMetaObject oldMeta, AbstractMetaObject newMeta, MetaDiff metaDiff, AbstractMetaObject oldParent, IDiffContext context) throws Exception {
        if (context.getActionMap() == null) {
            return;
        }
        IDiffAction action = context.getActionMap().getDiffAction(newMeta);
        if (action != null) {
            action.doDivide(key, oldMeta, newMeta, metaDiff, oldParent, null, context);
        }
    }

    protected AbstractMetaObject createBaseDiffMeta(String key, T oldMeta, T newMeta, MetaDiffNode diffNode, IDiffMetaEnv env) throws Exception {
        return diffCreator.createBaseDiffMeta(key, (AbstractMetaObject)oldMeta, (AbstractMetaObject)newMeta, diffNode, (IMetaEnv)env);
    }

    protected void mergeBaseDiffMeta(T meta, AbstractMetaObject diffMetaObject, MetaDiffNode metaDiffNode, IMetaEnv env) throws Exception {
        if (diffMetaObject == null) {
            return;
        }
        Document baseDoc = DiffMetaDomUtil.trans2DocumentSingle(meta, env);
        Document diffDoc = DiffMetaDomUtil.trans2DocumentSingle(diffMetaObject, env);
        Element baseElement = baseDoc.getDocumentElement();
        Element diffElement = diffDoc.getDocumentElement();
        DiffMetaDomUtil.mergeElementAttrs(baseElement, diffElement, metaDiffNode);
        meta.traversalSingle(env, (Object)baseDoc, (Object)baseElement, (Object)false, 2);
    }

    protected boolean canMergeWithoutDiffNode() {
        return false;
    }

    public abstract boolean mergeDiffNode(T var1, MetaDiff var2, MetaDiffNode var3, IDiffContext var4) throws Exception;

    public abstract void divideSubNode(T var1, T var2, AbstractMetaObject var3, MetaDiffNode var4, MetaDiff var5, IDiffContext var6) throws Exception;
}

