/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.style;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateFieldDisplay;
import com.bokesoft.yes.excel.template.ExcelTemplateFieldFormat;
import com.bokesoft.yes.excel.template.style.IExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class StampExcelStyleFactory
implements IExcelStyleFactory<ExcelTemplateField> {
    private Workbook workbook = null;
    private boolean isExcelFormatTemplate = false;
    private HashMap<String, CellStyle> styleMap = new HashMap();
    private CellStyle defaultStyle = null;

    public StampExcelStyleFactory(Workbook workbook, boolean isExcelFormatTemplate) {
        this.workbook = workbook;
        this.isExcelFormatTemplate = isExcelFormatTemplate;
        this.defaultStyle = workbook.createCellStyle();
        this.defaultStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.defaultStyle.setAlignment(HorizontalAlignment.CENTER);
        this.defaultStyle.setFont(this.createDefaultFont(workbook));
    }

    @Override
    public CellStyle getCellStyle(ExcelTemplateField templatField) {
        if (this.isExcelFormatTemplate) {
            return this.getSheetCellStyle(templatField);
        }
        return this.getMetaFieldStyle(templatField);
    }

    private CellStyle getSheetCellStyle(ExcelTemplateField templatField) {
        String sheetName = templatField.getSheetName();
        Sheet sheet = ExcelUtil.getSheet(this.workbook, sheetName);
        Cell cell = ExcelUtil.getCell(sheet, templatField.getRowIndex(), templatField.getColIndex());
        return cell.getCellStyle();
    }

    private CellStyle getMetaFieldStyle(ExcelTemplateField templatField) {
        CellStyle cellStyle = null;
        ExcelTemplateFieldDisplay display = templatField.getDisplay();
        ExcelTemplateFieldFormat format = templatField.getFormat();
        if ((display == null || display.isNullDisplayStyle()) && (format == null || format.isNullFormatStyle())) {
            return this.defaultStyle;
        }
        String key = display.toString() + "|" + format.toString();
        if (this.styleMap.containsKey(key)) {
            cellStyle = this.styleMap.get(key);
        }
        if (cellStyle == null) {
            short formatType;
            cellStyle = this.workbook.createCellStyle();
            this.styleMap.put(key, cellStyle);
            cellStyle.setAlignment(this.tranExcelHAlignment(display.getHAlignment()));
            cellStyle.setVerticalAlignment(this.tranExcelVAlignment(display.getVAlignment()));
            cellStyle.setWrapText(display.isWrapText());
            Font font = this.createDefaultFont(this.workbook);
            Font cellFont = this.workbook.createFont();
            cellFont.setBold(display.isFontBold());
            cellFont.setItalic(display.isFontItalic());
            cellFont.setFontName(display.getFontName());
            cellFont.setFontHeightInPoints((short)display.getFontSize());
            String foreColor = display.getForeColor();
            if (!foreColor.isEmpty()) {
                font.setColor(IndexedColors.valueOf((String)foreColor.toUpperCase()).index);
            }
            cellStyle.setFont(font);
            String backColor = display.getBackColor();
            if (!backColor.isEmpty()) {
                cellStyle.setFillForegroundColor(IndexedColors.valueOf((String)backColor.toUpperCase()).index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            cellStyle.setBorderLeft(this.tranExcelBorder(display.getBorderLeftStyle()));
            cellStyle.setBorderTop(this.tranExcelBorder(display.getBorderTopStyle()));
            cellStyle.setBorderRight(this.tranExcelBorder(display.getBorderRightStyle()));
            cellStyle.setBorderBottom(this.tranExcelBorder(display.getBorderBottomStyle()));
            String sColor = display.getBorderLeftColor();
            if (!sColor.isEmpty()) {
                cellStyle.setLeftBorderColor(IndexedColors.valueOf((String)sColor.toUpperCase()).index);
            }
            if (!(sColor = display.getBorderTopColor()).isEmpty()) {
                cellStyle.setTopBorderColor(IndexedColors.valueOf((String)sColor.toUpperCase()).index);
            }
            if (!(sColor = display.getBorderRightColor()).isEmpty()) {
                cellStyle.setRightBorderColor(IndexedColors.valueOf((String)sColor.toUpperCase()).index);
            }
            if (!(sColor = display.getBorderBottomColor()).isEmpty()) {
                cellStyle.setBottomBorderColor(IndexedColors.valueOf((String)sColor.toUpperCase()).index);
            }
            if ((formatType = this.getExcelDataFormatType(templatField.getFormatString(), this.workbook)) != -1) {
                cellStyle.setDataFormat(formatType);
            }
        }
        cellStyle.setWrapText(display.isWrapText());
        return cellStyle;
    }

    private short getExcelDataFormatType(String sFormat, Workbook workbook) {
        short formatType = -1;
        if (!StringUtil.isBlankOrNull((String)sFormat)) {
            DataFormat dataFormat = workbook.createDataFormat();
            formatType = dataFormat.getFormat(sFormat);
        }
        return formatType;
    }

    private HorizontalAlignment tranExcelHAlignment(int hAlignment) {
        HorizontalAlignment excelHAlignment = HorizontalAlignment.CENTER;
        switch (hAlignment) {
            case 1: {
                excelHAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case 0: {
                excelHAlignment = HorizontalAlignment.LEFT;
                break;
            }
            case 2: {
                excelHAlignment = HorizontalAlignment.RIGHT;
            }
        }
        return excelHAlignment;
    }

    private VerticalAlignment tranExcelVAlignment(int vAlignment) {
        VerticalAlignment excelVAlignment = VerticalAlignment.CENTER;
        switch (vAlignment) {
            case 1: {
                excelVAlignment = VerticalAlignment.CENTER;
                break;
            }
            case 2: {
                excelVAlignment = VerticalAlignment.BOTTOM;
                break;
            }
            case 0: {
                excelVAlignment = VerticalAlignment.TOP;
            }
        }
        return excelVAlignment;
    }

    private BorderStyle tranExcelBorder(int boder) {
        BorderStyle boderType = BorderStyle.NONE;
        switch (boder) {
            case 0: {
                boderType = BorderStyle.NONE;
                break;
            }
            case 1: {
                boderType = BorderStyle.DOUBLE;
                break;
            }
            case 2: {
                boderType = BorderStyle.THIN;
                break;
            }
            case 3: {
                boderType = BorderStyle.MEDIUM;
                break;
            }
            case 4: {
                boderType = BorderStyle.DASHED;
                break;
            }
            case 5: {
                boderType = BorderStyle.HAIR;
                break;
            }
            case 6: {
                boderType = BorderStyle.THICK;
            }
        }
        return boderType;
    }

    private Font createDefaultFont(Workbook workbook) {
        Font font = workbook.createFont();
        font.setBold(false);
        font.setItalic(false);
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)12);
        return font;
    }

    public CellStyle getDefaultStyle() {
        return this.defaultStyle;
    }
}

