/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.creator;

import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.creator.AbstractStampWorkbookCreator;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelTemplateUtils;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import java.io.IOException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StampWorkbookCreator
extends AbstractStampWorkbookCreator {
    private static final int TEMPLATE_VERSION = 1;

    public StampWorkbookCreator(ExcelTemplate excelTemplate) {
        super(excelTemplate);
    }

    @Override
    public Workbook create() throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sysSheet = ExcelUtil.getSheet((Workbook)workbook, "YIGO_TEMPLATE");
        workbook.setSheetHidden(workbook.getSheetIndex(sysSheet), true);
        StampExcelStyleFactory styleFactory = new StampExcelStyleFactory((Workbook)workbook, false);
        this.prepareSystemColumnCaption(sysSheet);
        this.prepareSystemSetting(sysSheet, workbook, styleFactory);
        this.prepareConstFields((Workbook)workbook, styleFactory);
        return workbook;
    }

    private void prepareConstFields(Workbook workbook, StampExcelStyleFactory styleFactory) {
        for (ExcelTemplateSheet templateSheet : this.excelTemplate.getTemplateSheets()) {
            for (ExcelTemplateTable templateTable : templateSheet.getTemplateTables()) {
                for (ExcelTemplateField field : templateTable.getFields()) {
                    if (2 != field.getSourceType()) continue;
                    Sheet sheet = ExcelUtil.getSheet(workbook, field.getSheetName());
                    ExcelUtil.prepareDefaultHeightRow(sheet, field.getRowIndex());
                    CellStyle cellStyle = styleFactory.getCellStyle(field);
                    ExcelUtil.setCellValue(sheet, field.getRowIndex(), field.getColIndex(), ExcelTemplateUtils.getBindFieldKeyStr(field), cellStyle);
                }
            }
        }
        if (this.excelTemplate.getType() != EExcelTemplateType.Single) {
            for (ExcelTemplateSheet templateSheet : this.excelTemplate.getTemplateSheets()) {
                Sheet sheet = ExcelUtil.getSheet(workbook, templateSheet.getSheetName());
                ExcelUtil.setCellValue(sheet, 0, 0, this.excelTemplate.getDataObjectKey());
            }
        }
    }

    private void prepareSystemColumnCaption(Sheet sysSheet) {
        int startRow = 0;
        ExcelUtil.prepareDefaultHeightRow(sysSheet, startRow);
        ExcelUtil.setCellValue(sysSheet, startRow, 0, "\u7248\u672c\u53f7");
        ExcelUtil.setCellValue(sysSheet, startRow, 1, "\u8868\u5355\u6807\u5fd7");
        ExcelUtil.setCellValue(sysSheet, startRow, 2, "\u6a21\u677f\u7c7b\u578b(Signle|Batch|MultiBatch)");
        ExcelUtil.setCellValue(sysSheet, startRow, 3, "\u9644\u52a0\u53c2\u6570(\u9884\u7559\u6269\u5c55\u5c5e\u6027)");
        ExcelUtil.setCellValue(sysSheet, startRow, 4, "\u8868\u6807\u5fd7");
        ExcelUtil.setCellValue(sysSheet, startRow, 5, "\u7ed1\u5b9a\u5355\u5143\u683c");
        ExcelUtil.setCellValue(sysSheet, startRow, 6, "\u5355\u5143\u683c\u6570\u636e\u6765\u6e90");
        ExcelUtil.setCellValue(sysSheet, startRow, 7, "\u5355\u5143\u683c\u6570\u636e\u6765\u6e90\u7c7b\u578b(Const|Field|Formula)");
        ExcelUtil.setCellValue(sysSheet, startRow, 8, "\u6570\u636e\u683c\u5f0f\u5b9a\u4e49");
        ExcelUtil.setCellValue(sysSheet, startRow, 9, "\u5b57\u6bb5\u68c0\u67e5\u516c\u5f0f");
        ExcelUtil.setCellValue(sysSheet, startRow, 10, "\u662f\u5426\u4e3a\u660e\u7ec6\u5173\u8054\u5b57\u6bb5(True|False)");
        ExcelUtil.setCellValue(sysSheet, startRow, 11, "\u662f\u5426\u5ffd\u7565\u5bfc\u5165(True|False)");
        ExcelUtil.setCellValue(sysSheet, startRow, 12, "\u662f\u5426\u5ffd\u7565\u5bfc\u51fa(\u5e73\u53f0\u516c\u5f0f)");
        ExcelUtil.setCellValue(sysSheet, startRow, 13, "\u5217\u6269\u5c55\u5b9a\u4e49");
        ExcelUtil.setCellValue(sysSheet, startRow, 14, "\u7ed1\u5b9a\u5217\u6269\u5c55\u6807\u9898");
    }

    private void prepareSystemSetting(Sheet sysSheet, XSSFWorkbook workbook, StampExcelStyleFactory styleFactory) {
        int startRow = 1;
        ExcelUtil.prepareDefaultHeightRow(sysSheet, startRow);
        ExcelUtil.setCellValue(sysSheet, startRow, 0, 1);
        ExcelUtil.setCellValue(sysSheet, startRow, 1, this.excelTemplate.getFormKey());
        ExcelUtil.setCellValue(sysSheet, startRow, 2, this.excelTemplate.getType().toString());
        for (ExcelTemplateTable templateTable : this.excelTemplate.getTemplateTables4StampExport()) {
            Sheet sheet;
            ExcelUtil.prepareDefaultHeightRow(sysSheet, startRow);
            ExcelUtil.setCellValue(sysSheet, startRow, 4, templateTable.getTableKey());
            for (ExcelTemplateField field : templateTable.getFields()) {
                ExcelUtil.prepareDefaultHeightRow(sysSheet, startRow);
                String bindCellStr = ExcelTemplateUtils.getBindCellStr(field.getSheetName(), field.getRowIndex() + 1, field.getColIndex() + 1);
                sheet = ExcelUtil.getSheet((Workbook)workbook, field.getSheetName());
                ExcelUtil.prepareSheet(sheet, 30);
                CellStyle cellStyle = styleFactory.getCellStyle(field);
                ExcelUtil.setCellValue(sheet, field.getRowIndex(), field.getColIndex(), ExcelTemplateUtils.getBindFieldKeyStr(field), cellStyle);
                if (this.excelTemplate.getType() != EExcelTemplateType.Single) {
                    String value = ExcelTemplateUtils.getImportFieldKeyStr4Old(field);
                    ExcelUtil.setCellValue(sheet, 0, field.getColIndex(), value, cellStyle);
                }
                ExcelUtil.setCellFormula(sysSheet, startRow, 5, bindCellStr);
                ExcelUtil.setCellValue(sysSheet, startRow, 6, field.getDefine());
                ExcelUtil.setCellValue(sysSheet, startRow, 7, ExcelTemplateCellType.toString((Integer)field.getSourceType()));
                ExcelUtil.setCellValue(sysSheet, startRow, 8, field.getFormat().toString());
                ExcelUtil.setCellValue(sysSheet, startRow, 11, field.isIgnore4Import());
                ExcelUtil.setCellValue(sysSheet, startRow, 10, field.isDetailLinkField());
                ExcelUtil.setCellValue(sysSheet, startRow, 12, field.getIgnoreExport());
                ExcelUtil.setCellValue(sysSheet, startRow, 13, field.getColumnExpand().toString());
                ExcelTemplateField detailHeadField = templateTable.getDetailHeadField(field.getColIndex());
                if (detailHeadField != null) {
                    bindCellStr = ExcelTemplateUtils.getBindCellStr(detailHeadField.getSheetName(), detailHeadField.getRowIndex() + 1, detailHeadField.getColIndex() + 1);
                    ExcelUtil.setCellFormula(sysSheet, startRow, 14, bindCellStr);
                }
                ++startRow;
            }
            ExcelTemplateField firstField = templateTable.getFirstField();
            if (!templateTable.isDtlTable() || firstField == null) continue;
            int rowIndex = firstField.getRowIndex();
            String sheetName = firstField.getSheetName();
            sheet = ExcelUtil.getSheet((Workbook)workbook, sheetName);
            Row row = ExcelUtil.getRow(sheet, rowIndex);
            row.setZeroHeight(true);
            if (this.excelTemplate.getType() == EExcelTemplateType.Single) continue;
            row = ExcelUtil.getRow(sheet, 0);
            row.setZeroHeight(true);
        }
    }
}

