/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.util;

import com.bokesoft.yes.automap.excel.template.AutoMapExcelSheet;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateFieldDisplay;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.builder.IExcelTemplateBuilder;
import com.bokesoft.yes.excel.template.builder.MetaBatchTemplateBuilder;
import com.bokesoft.yes.excel.template.builder.MetaMultiBatchTemplateBuilder;
import com.bokesoft.yes.excel.template.builder.MetaSingleTemplateBuilder;
import com.bokesoft.yes.excel.template.builder.SheetTemplateBuilder;
import com.bokesoft.yes.excel.template.creator.StampWorkbookCreator;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelBorder;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumnExpand;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelDisplay;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFont;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelListItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.util.MetaUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelTemplateUtils {
    public static ExcelTemplate getExcelTemplate(String templateKey, EExcelTemplateType type, MetaForm metaForm, AbstractRuntimeUIConfig runtimeUIConfig, IMetaFactory metaFactory) throws Throwable {
        String xlsTemplateKey;
        String projectKey = metaForm.getProject().getKey();
        byte[] bytes = metaFactory.getExcelFileTemplate(projectKey, xlsTemplateKey = ExcelTemplateUtils.getXlsExcelFileName(templateKey, type.toString(), ".xls"));
        if (bytes == null) {
            xlsTemplateKey = ExcelTemplateUtils.getXlsExcelFileName(templateKey, type.toString(), ".xlsx");
            bytes = metaFactory.getExcelFileTemplate(projectKey, xlsTemplateKey);
        }
        if (bytes != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            SheetTemplateBuilder templateBuilder = new SheetTemplateBuilder(xlsTemplateKey, workbook, metaFactory);
            return templateBuilder.create();
        }
        MetaExcelWorkbook metaWorkBook = ExcelTemplateUtils.getMetaExcelWorkbook(templateKey, type, metaForm, runtimeUIConfig, metaFactory);
        MetaForm metaForm4Export = metaFactory.getMetaForm(metaWorkBook.getFormKey());
        MetaDataObject metaDataObject4Export = MetaUtil.getDataObject((IMetaFactory)metaFactory, (MetaForm)metaForm4Export);
        return ExcelTemplateUtils.createExcelTemplateByMeta(metaWorkBook, metaDataObject4Export, type);
    }

    public static Workbook createTemplateExcelWorkbook(ExcelTemplate excelTemplate, String projectKey, IMetaFactory metaFactory) throws Throwable {
        Workbook workbook = null;
        String templateKey = excelTemplate.getKey();
        if (excelTemplate.isExcelFormatTemplate()) {
            byte[] bytes = metaFactory.getExcelFileTemplate(projectKey, templateKey);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            workbook = WorkbookFactory.create((InputStream)is);
        } else {
            StampWorkbookCreator workbookBuilder = new StampWorkbookCreator(excelTemplate);
            workbook = workbookBuilder.create();
        }
        return workbook;
    }

    public static MetaExcelWorkbook getMetaExcelWorkbook(String templateKey, EExcelTemplateType type, MetaForm metaForm, AbstractRuntimeUIConfig runtimeUIConfig, IMetaFactory metaFactory) throws Throwable {
        boolean bBatch = type != EExcelTemplateType.Single && type != EExcelTemplateType.Single_V0;
        boolean bExportWithTemplate = type == EExcelTemplateType.SingleBatch_V0 || type == EExcelTemplateType.Single_V0;
        String projectKey = metaForm.getProject().getKey();
        if (!StringUtil.isBlankOrNull((String)templateKey)) {
            MetaExcelWorkbook metaWorkBook = metaFactory.getExcelTemplate(projectKey, templateKey);
            if (metaWorkBook == null) {
                throw new RuntimeException("Excel\u6a21\u677f[" + templateKey + "]\u4e0d\u5b58\u5728!");
            }
            if (!bBatch && !metaForm.getKey().equalsIgnoreCase(metaWorkBook.getFormKey())) {
                throw new RuntimeException("Excel\u6a21\u677f[" + templateKey + "]\u4e0e\u5f53\u524d\u8868\u5355\u4e0d\u5339\u914d!");
            }
            return metaWorkBook;
        }
        if (bBatch) {
            MetaForm baseForm = ExcelTemplateUtils.getMetaFormByView(metaForm, metaFactory);
            return ExcelTemplateUtils.createDefaultExcelTemplate(baseForm, null, metaFactory, bExportWithTemplate);
        }
        return ExcelTemplateUtils.createDefaultExcelTemplate(metaForm, runtimeUIConfig, metaFactory, bExportWithTemplate);
    }

    public static MetaExcelWorkbook getMetaWorkbookWithDefault(String templateKey, MetaForm metaForm, AbstractRuntimeUIConfig runtimeUIConfig, IMetaFactory metaFactory) throws Throwable {
        if (StringUtil.isBlankOrNull((String)templateKey)) {
            return ExcelTemplateUtils.createDefaultExcelTemplate(metaForm, runtimeUIConfig, metaFactory, true);
        }
        return metaFactory.getExcelTemplate(metaForm.getProjectKey(), templateKey);
    }

    private static MetaExcelWorkbook createDefaultExcelTemplate(MetaForm metaForm, AbstractRuntimeUIConfig runtimeUIConfig, IMetaFactory metaFactory, boolean bExportWithTemplate) throws Throwable {
        MetaStatusCollection statusCollection = MetaUtil.getStatusCollection((IMetaFactory)metaFactory, (MetaForm)metaForm);
        AutoMapExcelSheet map = new AutoMapExcelSheet(metaForm, statusCollection);
        return map.map(runtimeUIConfig, bExportWithTemplate);
    }

    private static MetaForm getMetaFormByView(MetaForm metaForm, IMetaFactory metaFactory) throws Throwable {
        if (metaForm.getFormType() == 3) {
            MetaForm tmpMetaForm = null;
            for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
                tmpMetaForm = metaFactory.getMetaForm(metaFormProfile.getKey());
                if (!metaForm.getKey().equalsIgnoreCase(tmpMetaForm.getViewKey())) continue;
                return metaFormProfile.getForm();
            }
        }
        return metaForm;
    }

    public static ExcelTemplate createExcelTemplateByMeta(MetaExcelWorkbook metaWorkbook, MetaDataObject metaDataObject, EExcelTemplateType type) throws Throwable {
        IExcelTemplateBuilder templateBuilder = null;
        switch (type) {
            case Single: {
                templateBuilder = new MetaSingleTemplateBuilder(metaWorkbook, metaDataObject);
                break;
            }
            case Batch: {
                templateBuilder = new MetaBatchTemplateBuilder(metaWorkbook, metaDataObject);
                break;
            }
            case MultiBatch: {
                templateBuilder = new MetaMultiBatchTemplateBuilder(metaWorkbook, metaDataObject);
                break;
            }
            default: {
                templateBuilder = new MetaSingleTemplateBuilder(metaWorkbook, metaDataObject);
            }
        }
        return templateBuilder.create();
    }

    public static void createSheetColumnSize(MetaExcelSheet metaSheet, ExcelTemplateSheet sheetTemplate) {
        if (metaSheet.getColumns() != null) {
            for (MetaExcelColumn metaColumn : metaSheet.getColumns()) {
                sheetTemplate.addColumnWidth(metaColumn.getColumnIndex(), metaColumn.getWidth());
            }
        }
    }

    public static ExcelTemplate createTemplate(String templateKey, String formKey, String dataObjectKey, boolean needResetCellIndex, EExcelTemplateType type) {
        ExcelTemplate excelTemplate = new ExcelTemplate(templateKey);
        excelTemplate.setVersion(1);
        excelTemplate.setFormKey(formKey);
        excelTemplate.setType(type);
        excelTemplate.setDataObjectKey(dataObjectKey);
        excelTemplate.setNeedResetCellIndex(needResetCellIndex);
        return excelTemplate;
    }

    public static void initTemplateFieldByMeta(ExcelTemplateField field, MetaExcelCell cell, boolean bBatch) {
        if (bBatch) {
            field.setDetailLinkField(cell.isDetailLinked());
        }
        field.setSourceType(cell.getSourceType());
        field.setColSpan(cell.getMergedColumnSpan());
        field.setRowSpan(cell.getMergedRowSpan());
        field.setTableKey(cell.getTableKey());
        field.setIgnoreExport(cell.getIgnoreExport());
        MetaExcelDisplay metaCellDisplay = cell.getDisplay();
        if (metaCellDisplay != null) {
            MetaExcelFormat metaCellFormat;
            MetaExcelFont metaFont;
            ExcelTemplateFieldDisplay templateDisplay = field.getDisplay();
            templateDisplay.setWrapText(metaCellDisplay.isWrapText());
            templateDisplay.setBackColor(metaCellDisplay.getBackColor());
            templateDisplay.setForeColor(metaCellDisplay.getForeColor());
            templateDisplay.setHAlignment(metaCellDisplay.getHAlign());
            templateDisplay.setVAlignment(metaCellDisplay.getVAlign());
            MetaExcelBorder metaBorder = metaCellDisplay.getBorder();
            if (metaBorder != null) {
                templateDisplay.setBorderLeftStyle(metaBorder.getLeftStyle());
                templateDisplay.setBorderLeftColor(metaBorder.getLeftColor());
                templateDisplay.setBorderTopStyle(metaBorder.getTopStyle());
                templateDisplay.setBorderTopColor(metaBorder.getTopColor());
                templateDisplay.setBorderRightStyle(metaBorder.getRightStyle());
                templateDisplay.setBorderRightColor(metaBorder.getRightColor());
                templateDisplay.setBorderBottomStyle(metaBorder.getBottomStyle());
                templateDisplay.setBorderBottomColor(metaBorder.getBottomColor());
            }
            if ((metaFont = metaCellDisplay.getFont()) != null) {
                templateDisplay.setFontName(metaFont.getName());
                templateDisplay.setFontSize(metaFont.getSize().shortValue());
                templateDisplay.setFontBold(metaFont.isBold());
                templateDisplay.setFontItalic(metaFont.isItalic());
            }
            if ((metaCellFormat = metaCellDisplay.getFormat()) != null) {
                field.setDataType(metaCellFormat.getDataType());
                field.setFieldKeys(metaCellFormat.getFieldKeys());
                field.setFormatString(metaCellFormat.getFormatString());
                field.setItemKey(metaCellFormat.getItemKey());
                field.setStorageService(metaCellFormat.getStorageService());
                if (metaCellFormat.getListItems() != null) {
                    for (MetaExcelListItem item : metaCellFormat.getListItems()) {
                        field.addListItem(item.getValue(), item.getText());
                    }
                }
            }
        }
        MetaExcelColumnExpand columnExpand = cell.getColumnExpand();
        if (cell.isColumnExpand().booleanValue() && columnExpand != null) {
            field.setExpandType(columnExpand.getExpandType());
            field.setExpandSourceType(columnExpand.getSourceType());
            field.setExpandContent(columnExpand.getContent());
            field.setItemKey(columnExpand.getItemKey());
        }
    }

    public static String getExcelCellKey(int row, int col) {
        return ExcelTemplateUtils.excelColIndexToStr(col) + row;
    }

    private static String excelColIndexToStr(int columnIndex) {
        if (columnIndex <= 0) {
            return null;
        }
        String columnStr = "";
        --columnIndex;
        do {
            if (columnStr.length() > 0) {
                --columnIndex;
            }
            columnStr = (char)(columnIndex % 26 + 65) + columnStr;
        } while ((columnIndex = (columnIndex - columnIndex % 26) / 26) > 0);
        return columnStr;
    }

    public static int excelColStrToNum(String colStr) {
        int num = 0;
        int result = 0;
        int length = colStr.length();
        for (int i = 0; i < length; ++i) {
            char ch = colStr.charAt(length - i - 1);
            num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }

    public static int[] excelCellStrToRowAndCol(String sCellStr) {
        String colStr = "";
        String rowStr = "";
        for (int i = 0; i < sCellStr.length(); ++i) {
            char ch = sCellStr.charAt(i);
            if (Character.isLetter(ch)) {
                colStr = colStr + ch;
                continue;
            }
            if (!Character.isDigit(ch)) continue;
            rowStr = rowStr + ch;
        }
        int colIndex = ExcelTemplateUtils.excelColStrToNum(colStr);
        int[] rowAndCol = new int[]{TypeConvertor.toInteger((Object)rowStr), TypeConvertor.toInteger((Object)colIndex)};
        return rowAndCol;
    }

    public static ExcelTemplateField parseCellBindingToTemplate(String sBinding, String sDefine) {
        int startIndex = sBinding.indexOf("(");
        int splitIndex = sBinding.indexOf("!");
        int endIndex = sBinding.indexOf(")");
        String sSheetName = sBinding.substring(startIndex + 1, splitIndex);
        sSheetName = StringUtil.replaceAll((String)sSheetName, (String)"'", (String)"");
        String sCellStr = sBinding.substring(splitIndex + 1, endIndex);
        if ("#REF!".equals(sCellStr)) {
            System.out.println("#REF!");
            return null;
        }
        int[] rowAndCol = ExcelTemplateUtils.excelCellStrToRowAndCol(sCellStr);
        ExcelTemplateField templateField = new ExcelTemplateField(sDefine, rowAndCol[0] - 1, rowAndCol[1] - 1, sSheetName);
        return templateField;
    }

    public static String getBindCellStr(String sheetName, int row, int col) {
        String cellKey = ExcelTemplateUtils.getExcelCellKey(row, col);
        return "AREAS(" + sheetName + "!" + cellKey + ")";
    }

    public static String getBindFieldKeyStr(ExcelTemplateField field) {
        switch (field.getSourceType()) {
            case 2: {
                return field.getDefine();
            }
            case 0: {
                StringBuilder sb = new StringBuilder("");
                sb.append("[").append(field.getDefine());
                if (!StringUtil.isBlankOrNull((String)field.getItemKey())) {
                    sb.append(";").append(field.getItemKey());
                }
                sb.append("]");
                return sb.toString();
            }
            case 1: {
                return "=" + field.getDefine();
            }
        }
        return field.getDefine();
    }

    public static String getImportFieldKeyStr4Old(ExcelTemplateField field) {
        switch (field.getSourceType()) {
            case 0: {
                StringBuilder sb = new StringBuilder("");
                sb.append(field.getDefine());
                if (!StringUtil.isBlankOrNull((String)field.getItemKey())) {
                    sb.append(";").append(field.getItemKey());
                }
                return sb.toString();
            }
        }
        return field.getDefine();
    }

    public static String getXlsExcelFileName(String templateKey, String sType, String sExcelFileType) {
        return templateKey + "_" + sType + sExcelFileType;
    }

    public static String parseToExpandTableKey(String tableKey) {
        return "__expand__" + tableKey;
    }
}

