/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.excel.template.ExcelTemplateColumn;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class ExcelTemplateSheet {
    private String sheetName = null;
    private List<ExcelTemplateColumn> columns = null;
    private LinkedHashMap<String, ExcelTemplateTable> mapTables = null;

    public ExcelTemplateSheet(String sheetName) {
        this.sheetName = sheetName;
        this.columns = new ArrayList<ExcelTemplateColumn>();
        this.mapTables = new LinkedHashMap();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public ExcelTemplateTable ensureTemplateTable(String tableKey) {
        if (!this.mapTables.containsKey(tableKey)) {
            this.mapTables.put(tableKey, new ExcelTemplateTable(tableKey));
        }
        return this.mapTables.get(tableKey);
    }

    public ExcelTemplateTable getTemplateTable(String tableKey) {
        return this.mapTables.get(tableKey);
    }

    public void addTemplateTable(ExcelTemplateTable templateTable) {
        this.mapTables.put(templateTable.getTableKey(), templateTable);
    }

    public void removeTemplateTable(ExcelTemplateTable templateTable) {
        this.mapTables.remove(templateTable.getTableKey());
    }

    public boolean containTableKey(String tableKey) {
        return this.mapTables.containsKey(tableKey);
    }

    public Collection<ExcelTemplateTable> getTemplateTables() {
        return this.mapTables.values();
    }

    public void addColumnWidth(int index, int width) {
        this.columns.add(ExcelTemplateColumn.create(index, width));
    }

    public List<ExcelTemplateColumn> getColumns() {
        return this.columns;
    }
}

