/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mq.creator;

import com.bokesoft.yigo.mq.consumer.interfaces.IMQConsumerFactory;
import com.bokesoft.yigo.mq.creator.IMQFactoryCreator;
import com.bokesoft.yigo.mq.producer.interfaces.IMQProducerFactory;
import com.bokesoft.yigo.mq.util.MQStringUtils;
import com.bokesoft.yigo.mq.util.PropertiesLoaderUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQFactoryCreator
implements IMQFactoryCreator {
    private static final Logger log = LoggerFactory.getLogger(MQFactoryCreator.class);
    private static Map<String, Properties> propertiesMap = new ConcurrentHashMap<String, Properties>();
    private static Map<String, IMQProducerFactory> producerFactoryMap = new ConcurrentHashMap<String, IMQProducerFactory>();
    private static Map<String, IMQConsumerFactory> consumerfactoryMap = new ConcurrentHashMap<String, IMQConsumerFactory>();
    private static MQFactoryCreator instance = new MQFactoryCreator();

    private MQFactoryCreator() {
        this.init();
    }

    public static MQFactoryCreator getInstance() {
        return instance;
    }

    private void init() {
        String path = this.getClass().getClassLoader().getResource("mqs.properties").getPath();
        Properties mqs = PropertiesLoaderUtil.readProperties(path);
        for (String key : mqs.stringPropertyNames()) {
            String propertiesName;
            Properties pro;
            if (null == this.getClass().getClassLoader().getResource(key + ".properties") || !this.validMQProps(pro = PropertiesLoaderUtil.readProperties(propertiesName = this.getClass().getClassLoader().getResource(key + ".properties").getPath()))) continue;
            propertiesMap.put(key, pro);
        }
    }

    private boolean validMQProps(Properties mqPro) {
        if (mqPro == null || mqPro.isEmpty()) {
            log.error(" mqPro is null!");
            return false;
        }
        if (MQStringUtils.isEmpty(mqPro.getProperty("type")) || MQStringUtils.isEmpty(mqPro.getProperty("duty")) || MQStringUtils.isEmpty(mqPro.getProperty("provider"))) {
            log.error(" mqPro is invalid!");
            return false;
        }
        return true;
    }

    private Properties readProps(String factoryName) throws Throwable {
        if (MQStringUtils.isEmpty(factoryName)) {
            return null;
        }
        if (propertiesMap.containsKey(factoryName)) {
            Properties pro = propertiesMap.get(factoryName);
            if (!this.validMQProps(pro)) {
                return null;
            }
            return pro;
        }
        String propertiesName = "resources/" + factoryName + ".properties";
        Properties pro = PropertiesLoaderUtil.readProperties(propertiesName);
        if (!this.validMQProps(pro)) {
            return null;
        }
        return pro;
    }

    @Override
    public IMQConsumerFactory createConsumerFactory(String factoryName) throws Throwable {
        Properties pro = this.readProps(factoryName);
        if (pro == null) {
            return null;
        }
        IMQConsumerFactory factory = null;
        if (consumerfactoryMap.containsKey(factoryName)) {
            factory = consumerfactoryMap.get(factoryName);
        } else {
            String provider = pro.getProperty("provider");
            Object obj = this.createClass(provider);
            factory = (IMQConsumerFactory)obj;
            this.registerFactory(factoryName, factory);
        }
        Map<String, String> map = this.properties2Map(pro);
        factory.init(map);
        return factory;
    }

    private Map<String, String> properties2Map(Properties pro) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : pro.stringPropertyNames()) {
            if (this.inValues(key) || MQStringUtils.isEmpty(pro.getProperty(key))) continue;
            map.put(key, pro.getProperty(key));
        }
        return map;
    }

    private boolean inValues(String key) {
        String[] arr = new String[]{"type", "duty", "provider"};
        HashSet<String> set = new HashSet<String>(Arrays.asList(arr));
        return set.contains(key);
    }

    public void registerFactory(String type, IMQConsumerFactory factory) throws Throwable {
        if (MQStringUtils.isEmpty(type) || factory == null) {
            log.error("type or factory is null!");
            throw new Exception("type or factory is null!");
        }
        if (!consumerfactoryMap.containsKey(type) && null != factory) {
            consumerfactoryMap.put(type, factory);
        }
    }

    public void registerFactory(String type, IMQProducerFactory factory) throws Throwable {
        if (MQStringUtils.isEmpty(type) || factory == null) {
            log.error("type or factory is null!");
            throw new Exception("type or factory is null!");
        }
        if (!producerFactoryMap.containsKey(type) && null != factory) {
            producerFactoryMap.put(type, factory);
        }
    }

    @Override
    public IMQProducerFactory createProducerFactory(String factoryName) throws Throwable {
        Properties pro = this.readProps(factoryName);
        if (pro == null) {
            return null;
        }
        IMQProducerFactory factory = null;
        String type = pro.getProperty("type");
        if (producerFactoryMap.containsKey(type)) {
            factory = producerFactoryMap.get(type);
        } else {
            String provider = pro.getProperty("provider");
            Object obj = this.createClass(provider);
            factory = (IMQProducerFactory)obj;
            this.registerFactory(type, factory);
        }
        Map<String, String> map = this.properties2Map(pro);
        factory.init(map);
        return factory;
    }

    private Object createClass(String className) throws Exception {
        Object obj = null;
        try {
            Class<?> c = Class.forName(className);
            obj = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw e;
        }
        return obj;
    }

    public Properties getMQProperties(String factoryName) throws Throwable {
        if (MQStringUtils.isEmpty(factoryName)) {
            return null;
        }
        if (propertiesMap.containsKey(factoryName)) {
            Properties pro = propertiesMap.get(factoryName);
            if (!this.validMQProps(pro)) {
                log.debug(factoryName + " is invalid!");
                return null;
            }
            return pro;
        }
        return null;
    }

    public void createAllConsumers() {
        for (String key : propertiesMap.keySet()) {
            Properties pro = propertiesMap.get(key);
            if (!"consumer".equals(pro.getProperty("duty"))) continue;
            try {
                IMQConsumerFactory factory = this.createConsumerFactory(key);
                factory.registConsumer();
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.error("createAllConsumers() is fail! FactoryName:" + key + "\n" + e);
            }
        }
    }

    public static void main(String[] args) {
    }
}

