/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.util;

import com.bokesoft.yes.common.util.StringUtil;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;

public class EnvUtil {
    public static final String createTempClientID() {
        String mac = EnvUtil.getMAC();
        if (StringUtil.isBlankOrNull((String)mac)) {
            UUID uuid = UUID.randomUUID();
            return uuid.toString();
        }
        return mac;
    }

    private static String hexByte(byte b) {
        String s = "000000" + Integer.toHexString(b);
        return s.substring(s.length() - 2);
    }

    public static String getMAC() {
        String mac_s = "";
        try {
            Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
            while (el.hasMoreElements()) {
                byte[] mac = el.nextElement().getHardwareAddress();
                if (mac == null) continue;
                mac_s = EnvUtil.hexByte(mac[0]) + "-" + EnvUtil.hexByte(mac[1]) + "-" + EnvUtil.hexByte(mac[2]) + "-" + EnvUtil.hexByte(mac[3]) + "-" + EnvUtil.hexByte(mac[4]) + "-" + EnvUtil.hexByte(mac[5]);
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        return mac_s;
    }

    public static String getFingerprintKey(String metaKey, String cmdKey, long userid) {
        StringBuilder sb = new StringBuilder();
        sb.append(metaKey).append("|").append(cmdKey).append("|").append(userid);
        return sb.toString();
    }
}

