/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.rights;

import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ServiceRights
implements JSONSerializable {
    private Set<String> serviceIDs = new HashSet<String>();
    private boolean hasAllRights = false;

    public boolean hasServiceRights(String serviceID) {
        if (this.hasAllRights) {
            return true;
        }
        return this.serviceIDs.contains(serviceID);
    }

    public void addServiceID(String serviceID) {
        if (this.hasAllRights) {
            return;
        }
        if ("*".equals(serviceID)) {
            this.hasAllRights = true;
        } else {
            this.serviceIDs.add(serviceID);
        }
    }

    public boolean hasAllRights() {
        return this.hasAllRights;
    }

    public void setHasAllRights(boolean hasAllRights) {
        this.hasAllRights = hasAllRights;
    }

    public Set<String> getServiceIDs() {
        return this.serviceIDs;
    }

    public void merge(ServiceRights rights) {
        if (rights == null || this.hasAllRights) {
            return;
        }
        if (rights.hasAllRights()) {
            this.hasAllRights = rights.hasAllRights();
            return;
        }
        this.serviceIDs.addAll(rights.getServiceIDs());
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject json = new JSONObject();
        if (this.hasAllRights) {
            json.put("allRights", true);
        } else {
            json.put("allRights", false);
            JSONArray array = new JSONArray();
            for (String ids : this.serviceIDs) {
                array.put((Object)ids);
            }
            json.put("ids", (Object)array);
        }
        return json;
    }

    public void fromJSON(JSONObject jsonObj) throws Throwable {
        if (jsonObj.has("allRights")) {
            this.hasAllRights = jsonObj.getBoolean("allRights");
        }
        if (!this.hasAllRights && jsonObj.has("ids")) {
            JSONArray array = jsonObj.getJSONArray("ids");
            this.serviceIDs.clear();
            for (int i = 0; i < array.length(); ++i) {
                this.serviceIDs.add(array.getString(i));
            }
        }
    }
}

